/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.user.openapi.facade.domain.params;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.service.user.openapi.facade.domain.params
 * 功能：代理商 菜单添加与更新参数
 * 创建时间：2017-12-18 20:40
 * 更新记录：
 * @author BuHao
 */
@Data
@Accessors(chain = true)
public class AgentNodeAddOrUpdateParam {

  /**
   * 归属节点
   */
  private Long parentId;
  /**
   * 节点名称
   */
  private String nodeName;
  /**
   * 跳转地址
   */
  private String action;
  /**
   * 图标地址
   */
  private String nodeIco;
  /**
   * 是否外链
   */
  private Integer isOutside;
  /**
   * 外链地址
   */
  private String outsideUrl;
  /**
   * 排序
   */
  private Integer sort;
  /**
   * 状态
   */
  private Integer status;
  /**
   * 节点 id
   */
  private Long nodeId;
  /**
   * 是否删除
   */
  private Integer isDel;
  /**
   * 是否显示子菜单
   */
  private Integer childShow;
  private Integer level;

}
