/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.fshows.lifecircle.service.user.openapi.facade.domain.merchant;


import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@AllArgsConstructor
@NoArgsConstructor
@Data
@Builder
public class MerchantQueryByAgentParam {

    /**
     * 分页查询 每页条数
     */
    private Integer pageSize = 20;

    /**
     * 第几页
     */
    private Integer page = 1;


    private boolean isExpire = false;

    /**
     * 商户ID
     */
    private Long mid;
    /**
     * 开此账号的代理商ID
     */
    private Long agentId;
    /**
     * 商户名称
     */
    private String title;
    /**
     * 用户名称
     */
    private String username;

    /**
     * grand name
     */
    private String grandname;
    /**
     * 是否过期 yes 、 no
     */
    private String expire;
    /**
     * 状态 1 启用 2锁定
     */
    private Integer status;

    /**
     * 代理商名称
     */
    private String company;

    Boolean expireFlag=false;
}
