/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.service.user.openapi.facade.api
 * 功能：
 * 创建时间：2017-12-12 15:15
 * 更新记录：
 *
 * @author BuHao
 */
package com.fshows.lifecircle.service.user.openapi.facade.api.rpc;

import com.fshows.lifecircle.service.user.openapi.facade.domain.constants.UserType;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.user.openapi.facade.domain.righconfig.RightConfigDTO;
import com.fshows.lifecircle.service.user.openapi.facade.domain.righconfig.RightControlDTO;

import java.util.List;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.service.user.openapi.facade.api
 * 功能：功能权限列表相关
 * 创建时间：2017-12-15 10:00
 * 更新记录：
 *
 * @author caofy
 */
public interface IUserRightConfigApi {

    /**
     * 按用户类型（oem/代理商/授理商/商户）获得功能权限列表接口
     *
     * @param type
     * @return
     */
    BizResponse<List<RightConfigDTO>> queryUserRightConfigList(UserType type);



    /**
     * 根据用户id 获得所拥有的功能权限列表
     *
     * @param type
     * @param userId
     * @return
     */
    BizResponse<List<RightControlDTO>> queryUserRightControlList(UserType type, long userId);

    /**
     * @author: Wendy
     * @description:添加修改的功能权限（按用户类型）
     * @date: 11:47 2017/12/18
     */
    BizResponse updateUserRightControl(Long userId, UserType type, String[] array);
}
