/**
 * Copyright (c) 2018, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.user.openapi.facade.domain.result;

import java.io.Serializable;
import lombok.Data;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.service.user.openapi.facade.domain.result
 * 功能：登录信息结果
 * 创建时间：2018-01-04 10:23
 * 更新记录：
 * @author BuHao
 */
@Data
public class AppLoginInfoResult implements Serializable {

  /**
   * 用户名
   */
  private String username;
  /**
   * 权限类型
   */
  private Integer roleType;
  /**
   * 登录 token
   */
  private String accessToken;
  /**
   * 店铺 id
   */
  private Long storeId;
  /**
   * 店铺名称
   */
  private String storeName;
  /**
   * 推送权限
   */
  private Integer isPush;
  /**
   * 主账号 id
   */
  private Long mid;
  /**
   * 用户 id (base_id)
   */
  private Long userId;
  /**
   * oem id 没有为0
   */
  private Long oemId;
  /**
   * 代理商 id 没有为0
   */
  private Long agentId = 0L;
  /**
   * 授理商 id 没有为0
   */
  private Long grantId = 0L;
}
