/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.user.openapi.facade.domain.merchant;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 功能：商户子账号请求参数对象
 * 创建时间：2017-12-15 10:00
 * 更新记录：
 *
 * @author caofy
 */

@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UserMerchantChildrenParam {

    /**
     * 商户ID
     */
    private Long mid;

    /**
     * 角色ID
     */
    private Long roleId;

    /**
     * 基础用户ID
     */
    private Long baseId;
    /**
     * 门店ID
     */
    private Long storeId;
    /**
     * 员工姓名
     */
    private String name;
    /**
     * 备注
     */
    private String remark;
    /**
     * 是否激活 1：是 0：否
     */
    private Integer status;
    /**
     * 是否删除 0否 1是
     */
    private Integer isDel;


    /**
     * 用户密码
     */
    private String userpwd;

    /**
     * 用户账号
     */
    private String username;

    /**
     * 手机号
     */
    private String mobile;
}
