/*
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.fshows.lifecircle.service.user.openapi.facade.api.rpc;


import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.AddOemConfigParma;
import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.AddOemNodeParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.AddOemNodeRightParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.AddOemParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.GetOemWebConfigParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.SearchOemParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.UpdateOemConfigParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.UpdateOemNodeParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.UpdateOemParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.OemNodeQueryParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.OemNodeResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.oem.*;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.BaseInfo;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.PageResult;

import java.util.List;

/**
 *
 *
 * @author  spafka
 * @create  2017-12-15
 *
 */
public interface IOemApi {


    BizResponse<UserOemDTO> addOem(AddOemParam param);

    BizResponse<Boolean>  updateOem(UpdateOemParam param);

    BizResponse  addOemConfig(AddOemConfigParma param);

    BizResponse<Boolean>  updateOemConfig(UpdateOemConfigParam param);



    /**
     * 查询（分页_模糊搜索）fb_user_oem
     *
     * @param param
     * @return
     */
    BizResponse<PageResult<SearchOemDTO>> searchOem(SearchOemParam param);

    BizResponse<OemResult> getOemByOemId(Long oemID);


    BizResponse<List<OemNodeResult>> getNodeByPage(OemNodeQueryParam param);

    // oem 添加站点权限
    BizResponse setOemNodeRight(AddOemNodeRightParam param);

    BizResponse<List<OemNodeRightDTO>> getOemNodeRightz(long oemId);


    /**
     * @deprecated  use IUserRightConfigApi instead
     * @return
     */
    @Deprecated
    BizResponse<List<OemRightConfigDTO> > getAllOemRight();


    BizResponse<List<BaseInfo>> getOemList();

    BizResponse<List<BaseInfo>> getOemListByOemId(Long oemId);
}
