/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.service.user.openapi.facade.api
 * 功能：
 * 创建时间：2017-12-12 15:15
 * 更新记录：
 *
 * @author BuHao
 */
package com.fshows.lifecircle.service.user.openapi.facade.api.rpc;

import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.*;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.PageResult;

import java.util.List;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.service.user.openapi.facade.api
 * 功能：商户管理api
 * 创建时间：2017-12-15 10:00
 * 更新记录：
 *
 * @author caofy
 */
public interface IUserMerchantApi {

    /**
     * 商户信息添加
     *
     * @param param
     * @return
     */
    BizResponse<UserMerchantResult> addUserMerchant(UserMerchantParam param);

    /**
     * 商户信息修改
     *
     * @param param
     * @return
     */
    BizResponse<Boolean> updateUserMerchant(UserMerchantParam param);

    /**
     * 查询商户信息
     *
     * @param mid
     * @return
     */
    BizResponse<MerchantDetailDTO> queryUserMerchantByMid(Long mid);


    /**
     * 分页查询 商户信息
     *
     * @param merchantQuery
     * @return
     */
    BizResponse<PageResult<UserMerchantDTO>> queryUserMerchantPage(MerchantQuery merchantQuery);

    /**
     * 按条件查询 商户信息信息列表 主要用于导出
     *
     * @param merchantQuery
     * @return
     */
    BizResponse<List<UserMerchantDTO>> queryUserMerchantListByCondition(MerchantQuery merchantQuery);

}
