/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.service.user.openapi.facade.api
 * 功能：
 * 创建时间：2017-12-12 15:15
 * 更新记录：
 *
 * @author BuHao
 */
package com.fshows.lifecircle.service.user.openapi.facade.api.rpc;

import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.BaseInfo;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.UserBaseParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.UserBaseResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;

/**
 * 功能：基础用户api
 * 创建时间：2017-12-15 10:00
 * 更新记录：
 * @author caofy
 */
public interface IUserBaseApi {

  /**
   * 基础用户信息添加
   * @return
   */
  BizResponse<UserBaseResult> addUserBase(UserBaseParam param);

  /**
   * 基础用户信息修改
   * @return
   */
  BizResponse<Boolean> updateUserBase(UserBaseParam param);


  /**
   * 基础用户信息删除
   * @return
   */
  BizResponse<Boolean> deleteUserBase(Long baseId);

  /**
   * 根据username查询
   * @return
   */
  BizResponse<BaseInfo> getUserBaseByUsername(String username);

  /**
   * 根据username查询
   * @return
   */
  BizResponse<BaseInfo> getUserBaseByBaseId(Long baseId);
}
