/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.user.openapi.facade.domain.result;

import java.io.Serializable;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.service.user.openapi.facade.domain.result
 * 功能：
 * 创建时间：2017-12-12 15:11
 * 更新记录：
 * @author BuHao
 */
public class LoginResult implements Serializable {

  /**
   * 用户 id (base_id)
   */
  private Long userId;
  /**
   * oem id 没有为0
   */
  private Long oemId;
  /**
   * 代理商 id 没有为0
   */
  private Long agentId = 0L;
  /**
   * 授理商 id 没有为0
   */
  private Long grantId = 0L;
  /**
   * 用户类型
   */
  private Integer userType;
  /**
   * 子账号
   */
  private Boolean isChild = false;
  /**
   * 是否是付呗自身(可以登录总后台)
   */
  private Boolean isSelf;

  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  public Long getOemId() {
    return oemId;
  }

  public void setOemId(Long oemId) {
    this.oemId = oemId;
  }

  public Long getAgentId() {
    return agentId;
  }

  public void setAgentId(Long agentId) {
    this.agentId = agentId;
  }

  public Long getGrantId() {
    return grantId;
  }

  public void setGrantId(Long grantId) {
    this.grantId = grantId;
  }

  public Integer getUserType() {
    return userType;
  }

  public void setUserType(Integer userType) {
    this.userType = userType;
  }

  public Boolean getChild() {
    return isChild;
  }

  public void setChild(Boolean child) {
    isChild = child;
  }

  public Boolean getSelf() {
    return isSelf;
  }

  public void setSelf(Boolean self) {
    isSelf = self;
  }

  @Override
  public String toString() {
    return "LoginResult{" +
        "userId=" + userId +
        ", oemId=" + oemId +
        ", agentId=" + agentId +
        ", grantId=" + grantId +
        ", userType=" + userType +
        ", isChild=" + isChild +
        ", isSelf=" + isSelf +
        '}';
  }
}
