/*
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.fshows.lifecircle.service.user.openapi.facade.domain.oem;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class AddOemNodeParam {


    /**
     * 节点ID
     */
    private Long nodeId;
    /**
     * 操作（action）
     */
    private String action;
    /**
     * 菜单名称
     */
    private String title;
    /**
     * 显示类型 0隐藏  1显示
     */
    private Integer isDisplay;
    /**
     * 备注说明
     */
    private String remark;
    /**
     * 父ID
     */
    private Long pid;
    /**
     * 节点等级
     */
    private Integer level;
    /**
     * 排序权重
     */
    private Integer sort;
    /**
     * 是否自营专属 1是 0否
     */

    private Integer isSelfSupport;
    /**
     * 是否删除 0否 1是
     */

    private Integer isDel;



}
