/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.service.user.openapi.facade.api
 * 功能：
 * 创建时间：2017-12-12 15:15
 * 更新记录：
 *
 * @author BuHao
 */
package com.fshows.lifecircle.service.user.openapi.facade.api.rpc;

import com.fshows.lifecircle.service.user.openapi.facade.domain.agent.AgentDetailDTO;
import com.fshows.lifecircle.service.user.openapi.facade.domain.agent.AgentQuery;
import com.fshows.lifecircle.service.user.openapi.facade.domain.agent.UserAgentDTO;
import com.fshows.lifecircle.service.user.openapi.facade.domain.agent.UserAgentGrantDTO;
import com.fshows.lifecircle.service.user.openapi.facade.domain.agent.UserAgentParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.agent.UserAgentResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.MerchantListSeachByAgentResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.MerchantQueryByAgentParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.agent.*;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.PageResult;

import java.util.List;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.service.user.openapi.facade.api
 * 功能：代理商、授理商api
 * 创建时间：2017-12-15 10:00
 * 更新记录：
 * @author caofy
 */
public interface IUserAgentApi {

  /**
   * 代理商信息添加
   * @param param
   * @return
   */
  BizResponse<UserAgentResult> addUserAgent(UserAgentParam param);

  /**
   * 代理商信息修改
   * @param param
   * @return
   */
  BizResponse<Boolean> updateUserAgent(UserAgentParam param);

  /**
   * 查询代理商信息
   * @param agentId
   * @return
   */
  BizResponse<AgentDetailDTO> queryUserAgentByAgentId(Long agentId);

  /**
   * 分页查询代理商信息
   * @param agentQuery
   * @return
   */
  BizResponse<PageResult<UserAgentDTO>> queryUserAgentPage(AgentQuery agentQuery);

  /**
   * 分页查询授理商信息
   * @param agentQuery
   * @return
   */
  BizResponse<PageResult<UserAgentGrantDTO>> queryUserAgentGrantPage(AgentQuery agentQuery);

    BizResponse<List<MerchantListSeachByAgentResult>> findMerchantListByAgent(MerchantQueryByAgentParam param);
  /**
   * 根据agentId查询username和所属代理商公司名称
   *
   * @param agentId
   * @return
   */
  BizResponse<AgentUserAndBelongResult> queryUserAgentNameAndBelongAgengName(Long agentId);

}
