/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.user.openapi.facade.domain.params;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.service.user.openapi.facade.domain.params
 * 功能：oem 菜单添加与更新参数
 * 创建时间：2017-12-18 20:40
 * 更新记录：
 * @author BuHao
 */
@Data
@Accessors(chain = true)
public class OemNodeAddOrUpdateParam {

  /**
   * 归属节点
   */
  private Long pid;
  /**
   * 排序
   */
  private Integer sort;
  /**
   * 节点名称
   */
  private String title;
  /**
   * 菜单方法
   */
  private String action;
  /**
   * 是否是总后台专属
   */
  private Integer isSelfSupport;
  /**
   * 状态
   */
  private Integer status;
  /**
   * 备注
   */
  private String remark;
  /**
   * 节点 id
   */
  private Long nodeId;
  /**
   * 是否删除
   */
  private Integer isDel;
  /**
   * 是否显示
   */
  private Integer isDisplay;
}
