/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.user.openapi.facade.domain.merchant;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 功能：商户子账号请求参数对象
 * 创建时间：2017-12-15 10:00
 * 更新记录：
 *
 * @author caofy
 */

@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UserMerchantChildrenParam {

    /**
     * 商户ID
     */
    private Long mid;

    /**
     * 角色ID
     */
    private Integer roleId;

    /**
     * 基础用户ID
     */
    private Long baseId;
    /**
     * 门店ID
     */
    private Long storeId;
    /**
     * 角色名称
     */
    private String name;
    /**
     * 备注
     */
    private String remark;
    /**
     * 是否激活 1：是 0：否
     */
    private Integer status;
    /**
     * 是否删除 0否 1是
     */
    private Integer isDel;

    /**
     * 是否可退款
     */
    private Integer isRefund;
    /**
     * 是否可收银
     */
    private Integer isCashier;


}
