package com.fshows.lifecircle.service.user.openapi.facade.domain.agent;


import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * 功能：授理商
 * 创建时间：2017-12-15 14:59
 * 更新记录：
 *
 * @author caofy
 */

@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UserAgentGrantDTO {

    /**
     * 代理商ID
     */
    private Long agentId;
    /**
     * 基础用户ID
     */
    private Long baseId;
    /**
     * OEM商ID
     */
    private Long oemId;
    /**
     * 开此账号的上级代理商ID
     */
    private Long belong;
    /**
     * 代理级别  受理商 0  1全国代理 2省级代理 3市级代理 4区域代理
     */
    private Integer level;
    /**
     * 是否自营 1是 0否
     */
    private Integer isSelfSupport;
    /**
     * 代理商到期时间
     */
    private String vipTime;
    /**
     * 代理商用户状态  1 启用 2 锁定
     */
    private Integer status;


    /**
     * 审核状态 0 待审核 1 审核通过 2审核失败
     */
    private Integer checkStatus;

    /**
     * 公司
     */
    private String company;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 最后一次登录时间
     */
    private Date lastLoginTime;

    /**
     * username
     */
    private String username;


    /**
     * 上级代理商名称
     */
    private String belongAgentName;

}
