/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.user.openapi.facade.domain.agent;

import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.UserBaseParam;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 功能：代理商查询对象
 * 创建时间：2017-12-15 10:00
 * 更新记录：
 *
 * @author caofy
 */

@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class AgentQuery {

    /*
     * 分页查询 每页条数
     */
    private Integer pageSize = 20;

    /**
     * 第几页
     */
    private Integer page = 1;

    private String startTime;

    private String endTime;

    private boolean isExpire = false;

    /**
     * 商户ID
     */
    private Long mid;
    /**
     * 基础用户ID
     */
    private Long baseId;
    /**
     * 开此账号的代理商ID
     */
    private Long agentId;
    /**
     * OEM商ID
     */
    private Long oemId;
    /**
     * 状态 1 启用 2锁定
     */
    private Integer status;
    /**
     * 等级
     */
    private Integer level;

    /**
     * 公司名称
     */
    private String company;

    /**
     * 用户名
     */
    private String username;
    /**
     * 审核状态 0 待审核 1 审核通过 2审核失败
     */
    private Integer checkStatus;
}
