/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.user.manager;

import com.alibaba.edas.configcenter.config.ConfigService;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="edas.conf")
public class EdasConf {
    private static final Logger log = LoggerFactory.getLogger(EdasConf.class);
    private String group;
    private Integer timeout;
    private String commonConfGroup;

    public String get(String name) {
        return this.get(name, this.group);
    }

    public String getCommon(String name) {
        return this.get(name, this.commonConfGroup);
    }

    public String get(String name, String group) {
        try {
            return ConfigService.getConfig((String)name, (String)group, (long)this.timeout.intValue());
        }
        catch (Exception e) {
            log.error("\u65b9\u6cd5: get \u53d1\u751f\u5f02\u5e38\uff0c \u53c2\u6570: name = {} ,\u5f02\u5e38: Ex = {}", (Object)name, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public Integer getInt(String name) {
        return this.getInt(name, this.group);
    }

    public Integer getCommonInt(String name) {
        return this.getInt(name, this.commonConfGroup);
    }

    public Integer getInt(String name, String group) {
        try {
            return Integer.valueOf(ConfigService.getConfig((String)name, (String)group, (long)this.timeout.intValue()));
        }
        catch (Exception e) {
            log.error("\u65b9\u6cd5: get \u53d1\u751f\u5f02\u5e38\uff0c \u53c2\u6570: name = {} ,\u5f02\u5e38: Ex = {}", (Object)name, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public Boolean getBool(String name) {
        return this.getBool(name, this.group);
    }

    public Boolean getCommonBool(String name) {
        return this.getBool(name, this.commonConfGroup);
    }

    public Boolean getBool(String name, String group) {
        try {
            return Boolean.valueOf(ConfigService.getConfig((String)name, (String)group, (long)this.timeout.intValue()));
        }
        catch (Exception e) {
            log.error("\u65b9\u6cd5: get \u53d1\u751f\u5f02\u5e38\uff0c \u53c2\u6570: name = {} ,\u5f02\u5e38: Ex = {}", (Object)name, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public static Logger getLog() {
        return log;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public String getCommonConfGroup() {
        return this.commonConfGroup;
    }

    public void setCommonConfGroup(String commonConfGroup) {
        this.commonConfGroup = commonConfGroup;
    }
}

