/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.user.manager;

import com.alibaba.edas.configcenter.config.ConfigService;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 项目：lifecircle-service-apigateway
 * 包名：com.fshows.lifecircle.service.apigateway.config
 * 功能：配置获取类
 * 创建时间：2017-11-23 10:54
 * 更新记录：
 *
 * @author BuHao
 */
@Component
@ConfigurationProperties(prefix = "edas.conf")
public class EdasConf {

  private static final Logger log = LoggerFactory.getLogger(EdasConf.class);


  /**
   * 配置组
   */
  private String group;
  /**
   * 配置获取超时
   */
  private Integer timeout;
  /**
   * 公共配置
   */
  private String commonConfGroup;

  /**
   * 从配置中心获得字符串配置
   *
   * @param name 配置名称
   * @author BuHao
   */
  public String get(String name) {

    return get(name, group);
  }


  /**
   * 从配置中心公共配置获得字符串配置
   *
   * @param name 配置名称
   * @author BuHao
   */
  public String getCommon(String name) {

    return get(name, commonConfGroup);
  }


  /**
   * 从配置中心获得字符串配置
   *
   * @param name 配置名称
   * @author BuHao
   */
  public String get(String name, String group) {

    try {
      return ConfigService.getConfig(name, group, timeout);
    } catch (Exception e) {

      log.error("方法: get 发生异常， 参数: name = {} ,异常: Ex = {}", name, ExceptionUtils.getStackTrace(e));
    }

    return null;
  }

  /**
   * 从配置中心获得整型配置
   *
   * @param name 配置名称
   * @author BuHao
   */
  public Integer getInt(String name) {

    return getInt(name, group);
  }

  /**
   * 从配置中心获得整型配置
   *
   * @param name 配置名称
   * @author BuHao
   */
  public Integer getCommonInt(String name) {

    return getInt(name, commonConfGroup);
  }

  /**
   * 从配置中心获得整型配置
   *
   * @param name 配置名称
   * @author BuHao
   */
  public Integer getInt(String name, String group) {

    try {
      return Integer.valueOf(ConfigService.getConfig(name, group, timeout));
    } catch (Exception e) {

      log.error("方法: get 发生异常， 参数: name = {} ,异常: Ex = {}", name, ExceptionUtils.getStackTrace(e));
    }

    return null;
  }

  /**
   * 从配置中心获得布尔型配置
   *
   * @param name 配置名称
   * @author BuHao
   */
  public Boolean getBool(String name) {

    return getBool(name, group);
  }


    /**
   * 从配置中心公共配置获得布尔型配置
   *
   * @param name 配置名称
   * @author BuHao
   */
  public Boolean getCommonBool(String name) {

    return getBool(name, commonConfGroup);
  }

  /**
   * 从配置中心获得布尔型配置
   *
   * @param name 配置名称
   * @author BuHao
   */
  public Boolean getBool(String name, String group) {

    try {
      return Boolean.valueOf(ConfigService.getConfig(name, group, timeout));
    } catch (Exception e) {

      log.error("方法: get 发生异常， 参数: name = {} ,异常: Ex = {}", name, ExceptionUtils.getStackTrace(e));
    }

    return null;
  }

  public static Logger getLog() {
    return log;
  }

  public String getGroup() {
    return group;
  }

  public void setGroup(String group) {
    this.group = group;
  }

  public Integer getTimeout() {
    return timeout;
  }

  public void setTimeout(Integer timeout) {
    this.timeout = timeout;
  }

  public String getCommonConfGroup() {
    return commonConfGroup;
  }

  public void setCommonConfGroup(String commonConfGroup) {
    this.commonConfGroup = commonConfGroup;
  }
}
