package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 商户信息
 * </p>
 *
 * @author BuHao
 * @since 2018-01-12
 */
@TableName("fb_user_merchant")
public class FbUserMerchant implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
	@TableId(value="id", type= IdType.AUTO)
	private Long id;
    /**
     * 旧系统商户token
     */
	@TableField("o_mid")
	private Integer oMid;
    /**
     * 商户ID
     */
	private Long mid;
    /**
     * 基础用户ID
     */
	@TableField("base_id")
	private Long baseId;
    /**
     * 开此账号的代理商ID
     */
	@TableField("agent_id")
	private Long agentId;
    /**
     * OEM商ID
     */
	@TableField("oem_id")
	private Long oemId;
    /**
     * 状态 1 启用 2锁定 
     */
	private Integer status;
    /**
     * 商户名称
     */
	private String title;
    /**
     * 类目ID
     */
	@TableField("category_id")
	private String categoryId;
    /**
     * 商户到期时间
     */
	@TableField("vip_time")
	private Long vipTime;
    /**
     * 备注说明
     */
	private String remark;
    /**
     * 联系人
     */
	private String linkmen;
    /**
     * 联系方式
     */
	private String contact;
    /**
     * 实名认证状态 0未认证 1已认证
     */
	@TableField("auth_status")
	private Integer authStatus;
    /**
     * 绑卡状态 0未绑定 1已绑定
     */
	@TableField("bind_status")
	private Integer bindStatus;
    /**
     * 是否已进件清算平台 0 未进件 1 已进件
     */
	@TableField("is_settled")
	private Integer isSettled;
    /**
     * 清算平台分配唯一ID
     */
	@TableField("liquidation_merchant_id")
	private String liquidationMerchantId;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Long getId() {
		return id;
	}

	public FbUserMerchant setId(Long id) {
		this.id = id;
		return this;
	}

	public Integer getoMid() {
		return oMid;
	}

	public FbUserMerchant setoMid(Integer oMid) {
		this.oMid = oMid;
		return this;
	}

	public Long getMid() {
		return mid;
	}

	public FbUserMerchant setMid(Long mid) {
		this.mid = mid;
		return this;
	}

	public Long getBaseId() {
		return baseId;
	}

	public FbUserMerchant setBaseId(Long baseId) {
		this.baseId = baseId;
		return this;
	}

	public Long getAgentId() {
		return agentId;
	}

	public FbUserMerchant setAgentId(Long agentId) {
		this.agentId = agentId;
		return this;
	}

	public Long getOemId() {
		return oemId;
	}

	public FbUserMerchant setOemId(Long oemId) {
		this.oemId = oemId;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public FbUserMerchant setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public String getTitle() {
		return title;
	}

	public FbUserMerchant setTitle(String title) {
		this.title = title;
		return this;
	}

	public String getCategoryId() {
		return categoryId;
	}

	public FbUserMerchant setCategoryId(String categoryId) {
		this.categoryId = categoryId;
		return this;
	}

	public Long getVipTime() {
		return vipTime;
	}

	public FbUserMerchant setVipTime(Long vipTime) {
		this.vipTime = vipTime;
		return this;
	}

	public String getRemark() {
		return remark;
	}

	public FbUserMerchant setRemark(String remark) {
		this.remark = remark;
		return this;
	}

	public String getLinkmen() {
		return linkmen;
	}

	public FbUserMerchant setLinkmen(String linkmen) {
		this.linkmen = linkmen;
		return this;
	}

	public String getContact() {
		return contact;
	}

	public FbUserMerchant setContact(String contact) {
		this.contact = contact;
		return this;
	}

	public Integer getAuthStatus() {
		return authStatus;
	}

	public FbUserMerchant setAuthStatus(Integer authStatus) {
		this.authStatus = authStatus;
		return this;
	}

	public Integer getBindStatus() {
		return bindStatus;
	}

	public FbUserMerchant setBindStatus(Integer bindStatus) {
		this.bindStatus = bindStatus;
		return this;
	}

	public Integer getIsSettled() {
		return isSettled;
	}

	public FbUserMerchant setIsSettled(Integer isSettled) {
		this.isSettled = isSettled;
		return this;
	}

	public String getLiquidationMerchantId() {
		return liquidationMerchantId;
	}

	public FbUserMerchant setLiquidationMerchantId(String liquidationMerchantId) {
		this.liquidationMerchantId = liquidationMerchantId;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbUserMerchant setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbUserMerchant setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String O_MID = "o_mid";

	public static final String MID = "mid";

	public static final String BASE_ID = "base_id";

	public static final String AGENT_ID = "agent_id";

	public static final String OEM_ID = "oem_id";

	public static final String STATUS = "status";

	public static final String TITLE = "title";

	public static final String CATEGORY_ID = "category_id";

	public static final String VIP_TIME = "vip_time";

	public static final String REMARK = "remark";

	public static final String LINKMEN = "linkmen";

	public static final String CONTACT = "contact";

	public static final String AUTH_STATUS = "auth_status";

	public static final String BIND_STATUS = "bind_status";

	public static final String IS_SETTLED = "is_settled";

	public static final String LIQUIDATION_MERCHANT_ID = "liquidation_merchant_id";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbUserMerchant{" +
			", id=" + id +
			", oMid=" + oMid +
			", mid=" + mid +
			", baseId=" + baseId +
			", agentId=" + agentId +
			", oemId=" + oemId +
			", status=" + status +
			", title=" + title +
			", categoryId=" + categoryId +
			", vipTime=" + vipTime +
			", remark=" + remark +
			", linkmen=" + linkmen +
			", contact=" + contact +
			", authStatus=" + authStatus +
			", bindStatus=" + bindStatus +
			", isSettled=" + isSettled +
			", liquidationMerchantId=" + liquidationMerchantId +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
