package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 用户登录日志表
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
@TableName("fb_user_login_log")
public class FbUserLoginLog implements Serializable {

    private static final long serialVersionUID = 1L;

	@TableId(value="id", type= IdType.AUTO)
	private Integer id;
    /**
     * 登录IP
     */
	@TableField("login_ip")
	private Long loginIp;
    /**
     * 基础用户id（base_id）
     */
	@TableField("user_id")
	private Long userId;
    /**
     * 平台类型 1 oem 后台 2 代理商后台 3商户后台 4 app
     */
	@TableField("platform_type")
	private Integer platformType;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;


	public Integer getId() {
		return id;
	}

	public FbUserLoginLog setId(Integer id) {
		this.id = id;
		return this;
	}

	public Long getLoginIp() {
		return loginIp;
	}

	public FbUserLoginLog setLoginIp(Long loginIp) {
		this.loginIp = loginIp;
		return this;
	}

	public Long getUserId() {
		return userId;
	}

	public FbUserLoginLog setUserId(Long userId) {
		this.userId = userId;
		return this;
	}

	public Integer getPlatformType() {
		return platformType;
	}

	public FbUserLoginLog setPlatformType(Integer platformType) {
		this.platformType = platformType;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbUserLoginLog setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public static final String ID = "id";

	public static final String LOGIN_IP = "login_ip";

	public static final String USER_ID = "user_id";

	public static final String PLATFORM_TYPE = "platform_type";

	public static final String CREATE_TIME = "create_time";

	@Override
	public String toString() {
		return "FbUserLoginLog{" +
			", id=" + id +
			", loginIp=" + loginIp +
			", userId=" + userId +
			", platformType=" + platformType +
			", createTime=" + createTime +
			"}";
	}
}
