package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableLogic;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 银行卡绑定信息
 * </p>
 *
 * @author BuHao
 * @since 2018-01-12
 */
@TableName("fb_bank_bind_info")
public class FbBankBindInfo implements Serializable {

    private static final long serialVersionUID = 1L;

	@TableId(value="id", type= IdType.AUTO)
	private Integer id;
    /**
     * 绑定信息唯一标识
     */
	@TableField("bind_id")
	private Long bindId;
    /**
     * 商户唯一标识
     */
	private Long mid;
    /**
     * 银行唯一标识
     */
	@TableField("bank_id")
	private Long bankId;
    /**
     * 超级网银号
     */
	@TableField("bank_no")
	private String bankNo;
    /**
     * 银行名
     */
	@TableField("bank_name")
	private String bankName;
    /**
     * 银行卡号
     */
	@TableField("acct_id")
	private String acctId;
    /**
     * 个人认证姓名
     */
	private String name;
    /**
     * 银行卡预留手机号
     */
	@TableField("bank_mobile")
	private String bankMobile;
    /**
     * 企业认证营业执照号
     */
	@TableField("license_number")
	private String licenseNumber;
    /**
     * 绑定类型 1个人绑定 2企业绑定
     */
	@TableField("bind_type")
	private Integer bindType;
    /**
     * 添加来源 1app端   2pc端
     */
	@TableField("add_from")
	private Integer addFrom;
    /**
     * 是否删除 0未删除 1已删除
     */
	@TableField("is_del")
    @TableLogic
	private Integer isDel;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Integer getId() {
		return id;
	}

	public FbBankBindInfo setId(Integer id) {
		this.id = id;
		return this;
	}

	public Long getBindId() {
		return bindId;
	}

	public FbBankBindInfo setBindId(Long bindId) {
		this.bindId = bindId;
		return this;
	}

	public Long getMid() {
		return mid;
	}

	public FbBankBindInfo setMid(Long mid) {
		this.mid = mid;
		return this;
	}

	public Long getBankId() {
		return bankId;
	}

	public FbBankBindInfo setBankId(Long bankId) {
		this.bankId = bankId;
		return this;
	}

	public String getBankNo() {
		return bankNo;
	}

	public FbBankBindInfo setBankNo(String bankNo) {
		this.bankNo = bankNo;
		return this;
	}

	public String getBankName() {
		return bankName;
	}

	public FbBankBindInfo setBankName(String bankName) {
		this.bankName = bankName;
		return this;
	}

	public String getAcctId() {
		return acctId;
	}

	public FbBankBindInfo setAcctId(String acctId) {
		this.acctId = acctId;
		return this;
	}

	public String getName() {
		return name;
	}

	public FbBankBindInfo setName(String name) {
		this.name = name;
		return this;
	}

	public String getBankMobile() {
		return bankMobile;
	}

	public FbBankBindInfo setBankMobile(String bankMobile) {
		this.bankMobile = bankMobile;
		return this;
	}

	public String getLicenseNumber() {
		return licenseNumber;
	}

	public FbBankBindInfo setLicenseNumber(String licenseNumber) {
		this.licenseNumber = licenseNumber;
		return this;
	}

	public Integer getBindType() {
		return bindType;
	}

	public FbBankBindInfo setBindType(Integer bindType) {
		this.bindType = bindType;
		return this;
	}

	public Integer getAddFrom() {
		return addFrom;
	}

	public FbBankBindInfo setAddFrom(Integer addFrom) {
		this.addFrom = addFrom;
		return this;
	}

	public Integer getIsDel() {
		return isDel;
	}

	public FbBankBindInfo setIsDel(Integer isDel) {
		this.isDel = isDel;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbBankBindInfo setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbBankBindInfo setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String BIND_ID = "bind_id";

	public static final String MID = "mid";

	public static final String BANK_ID = "bank_id";

	public static final String BANK_NO = "bank_no";

	public static final String BANK_NAME = "bank_name";

	public static final String ACCT_ID = "acct_id";

	public static final String NAME = "name";

	public static final String BANK_MOBILE = "bank_mobile";

	public static final String LICENSE_NUMBER = "license_number";

	public static final String BIND_TYPE = "bind_type";

	public static final String ADD_FROM = "add_from";

	public static final String IS_DEL = "is_del";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbBankBindInfo{" +
			", id=" + id +
			", bindId=" + bindId +
			", mid=" + mid +
			", bankId=" + bankId +
			", bankNo=" + bankNo +
			", bankName=" + bankName +
			", acctId=" + acctId +
			", name=" + name +
			", bankMobile=" + bankMobile +
			", licenseNumber=" + licenseNumber +
			", bindType=" + bindType +
			", addFrom=" + addFrom +
			", isDel=" + isDel +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
