package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * APP登录记录表
 * </p>
 *
 * @author BuHao
 * @since 2018-01-03
 */
@TableName("fb_app_login_log")
public class FbAppLoginLog implements Serializable {

    private static final long serialVersionUID = 1L;

	@TableId(value="id", type= IdType.AUTO)
	private Integer id;
    /**
     * 基础用户id（base_id）
     */
	@TableField("user_id")
	private Long userId;
    /**
     * 授权token
     */
	@TableField("access_token")
	private String accessToken;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Integer getId() {
		return id;
	}

	public FbAppLoginLog setId(Integer id) {
		this.id = id;
		return this;
	}

	public Long getUserId() {
		return userId;
	}

	public FbAppLoginLog setUserId(Long userId) {
		this.userId = userId;
		return this;
	}

	public String getAccessToken() {
		return accessToken;
	}

	public FbAppLoginLog setAccessToken(String accessToken) {
		this.accessToken = accessToken;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbAppLoginLog setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbAppLoginLog setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String USER_ID = "user_id";

	public static final String ACCESS_TOKEN = "access_token";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbAppLoginLog{" +
			", id=" + id +
			", userId=" + userId +
			", accessToken=" + accessToken +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
