package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableLogic;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 代理商菜单表
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
@TableName("fb_agent_node")
public class FbAgentNode implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
	@TableId(value="id", type= IdType.AUTO)
	private Long id;
    /**
     * 菜单节点ID
     */
	@TableField("node_id")
	private Long nodeId;
    /**
     * 控制器
     */
	private String action;
    /**
     * 菜单节点名称
     */
	@TableField("node_name")
	private String nodeName;
    /**
     * 菜单节点图标 1级菜单才需要
     */
	@TableField("node_ico")
	private String nodeIco;
    /**
     * 上级菜单ID
     */
	@TableField("parent_id")
	private Long parentId;
    /**
     * 0 1级菜单 1 2级菜单 以此类推
     */
	private Integer level;
    /**
     * 是否对商户展示 0不展示 1展示 
     */
	private Integer status;
    /**
     * 子账户是否显示 0 不显示 1 显示
     */
	@TableField("child_show")
	private Integer childShow;
    /**
     * 是否外部链接 1是 0否
     */
	@TableField("is_outside")
	private Integer isOutside;
    /**
     * 外部链接URL
     */
	@TableField("outside_url")
	private String outsideUrl;
    /**
     * 降序排列
     */
	private Integer sort;
    /**
     * 是否删除 0否 1是
     */
	@TableField("is_del")
    @TableLogic
	private Integer isDel;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Long getId() {
		return id;
	}

	public FbAgentNode setId(Long id) {
		this.id = id;
		return this;
	}

	public Long getNodeId() {
		return nodeId;
	}

	public FbAgentNode setNodeId(Long nodeId) {
		this.nodeId = nodeId;
		return this;
	}

	public String getAction() {
		return action;
	}

	public FbAgentNode setAction(String action) {
		this.action = action;
		return this;
	}

	public String getNodeName() {
		return nodeName;
	}

	public FbAgentNode setNodeName(String nodeName) {
		this.nodeName = nodeName;
		return this;
	}

	public String getNodeIco() {
		return nodeIco;
	}

	public FbAgentNode setNodeIco(String nodeIco) {
		this.nodeIco = nodeIco;
		return this;
	}

	public Long getParentId() {
		return parentId;
	}

	public FbAgentNode setParentId(Long parentId) {
		this.parentId = parentId;
		return this;
	}

	public Integer getLevel() {
		return level;
	}

	public FbAgentNode setLevel(Integer level) {
		this.level = level;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public FbAgentNode setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public Integer getChildShow() {
		return childShow;
	}

	public FbAgentNode setChildShow(Integer childShow) {
		this.childShow = childShow;
		return this;
	}

	public Integer getIsOutside() {
		return isOutside;
	}

	public FbAgentNode setIsOutside(Integer isOutside) {
		this.isOutside = isOutside;
		return this;
	}

	public String getOutsideUrl() {
		return outsideUrl;
	}

	public FbAgentNode setOutsideUrl(String outsideUrl) {
		this.outsideUrl = outsideUrl;
		return this;
	}

	public Integer getSort() {
		return sort;
	}

	public FbAgentNode setSort(Integer sort) {
		this.sort = sort;
		return this;
	}

	public Integer getIsDel() {
		return isDel;
	}

	public FbAgentNode setIsDel(Integer isDel) {
		this.isDel = isDel;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbAgentNode setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbAgentNode setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String NODE_ID = "node_id";

	public static final String ACTION = "action";

	public static final String NODE_NAME = "node_name";

	public static final String NODE_ICO = "node_ico";

	public static final String PARENT_ID = "parent_id";

	public static final String LEVEL = "level";

	public static final String STATUS = "status";

	public static final String CHILD_SHOW = "child_show";

	public static final String IS_OUTSIDE = "is_outside";

	public static final String OUTSIDE_URL = "outside_url";

	public static final String SORT = "sort";

	public static final String IS_DEL = "is_del";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbAgentNode{" +
			", id=" + id +
			", nodeId=" + nodeId +
			", action=" + action +
			", nodeName=" + nodeName +
			", nodeIco=" + nodeIco +
			", parentId=" + parentId +
			", level=" + level +
			", status=" + status +
			", childShow=" + childShow +
			", isOutside=" + isOutside +
			", outsideUrl=" + outsideUrl +
			", sort=" + sort +
			", isDel=" + isDel +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
