/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.user.service.domain.po;

import lombok.Data;

import java.util.Date;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.domain.po
 * 功能：
 * 创建时间：2018-01-03 10:10
 * 更新记录：
 *
 * @author caofy
 */
@Data
public class MerchantPO {

    /**
     * 商户ID
     */
    private Long mid;

    /**
     * 代理商ID
     */
    private Long agentId;
    /**
     * 基础用户ID
     */
    private Long baseId;
    /**
     * OEM商ID
     */
    private Long oemId;
    /**
     * 开此账号的上级代理商ID
     */
    private Long belong;
    /**
     * 代理商到期时间
     */
    private String vipTime;
    /**
     * 代理商用户状态  1 启用 2 锁定
     */
    private Integer status;

    /**
     * 最后登录时间
     */
    private Date lastLoginTime;

    /**
     * 创建时间
     */
    private Date createTime;


    /**
     * username
     */
    private String username;

    private String provinceName;
    /**
     * 城市名称（gaode）
     */
    private String cityName;
    /**
     * 区域名称（gaode）
     */
    private String areaName;

    /**
     * 代理商公司名称
     */
    private String company;

    /**
     * 商户名称
     */
    private String title;


}
