package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 代理商信息
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
@Data
@TableName("fb_user_agent")
public class FbUserAgent implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
	@TableId(value="id", type= IdType.AUTO)
	private Long id;
    /**
     * 旧系统代理商ID
     */
	@TableField("o_agent_d")
	private Integer oAgentD;
    /**
     * 代理商ID
     */
	@TableField("agent_id")
	private Long agentId;
    /**
     * 基础用户ID
     */
	@TableField("base_id")
	private Long baseId;
    /**
     * OEM商ID
     */
	@TableField("oem_id")
	private Long oemId;
    /**
     * 代理费用 单位：元
     */
	@TableField("agent_fee")
	private Integer agentFee;
    /**
     * 开此账号的上级代理商ID
     */
	private Long belong;
    /**
     * 代理级别  受理商 0  1全国代理 2省级代理 3市级代理 4区域代理
     */
	private Integer level;
    /**
     * 是否自营 1是 0否
     */
	@TableField("is_self_support")
	private Integer isSelfSupport;
    /**
     * 代理商到期时间
     */
	@TableField("vip_time")
	private Long vipTime;
    /**
     * 代理商用户状态  1 启用 2 锁定
     */
	private Integer status;
    /**
     * 审核状态 0 待审核 1 审核通过 2审核失败
     */
	@TableField("check_status")
	private Integer checkStatus;
    /**
     * 审核时间
     */
	@TableField("check_time")
	private Long checkTime;
    /**
     * 备注说明
     */
	private String remark;
    /**
     * 公司
     */
	private String company;
    /**
     * 代理省份code（gaode）
     */
	@TableField("agent_province_code")
	private String agentProvinceCode;
    /**
     * 代理省份名称
     */
	@TableField("agent_province_name")
	private String agentProvinceName;
    /**
     * 代理城市code（gaode）
     */
	@TableField("agent_city_code")
	private String agentCityCode;
    /**
     * 代理城市名称
     */
	@TableField("agent_city_name")
	private String agentCityName;
    /**
     * 代理区域code（gaode）
     */
	@TableField("agent_area_code")
	private String agentAreaCode;
    /**
     * 代理区域名称
     */
	@TableField("agent_area_name")
	private String agentAreaName;
    /**
     * 所属行业
     */
	private String industry;
    /**
     * 主营业务
     */
	@TableField("main_biz")
	private String mainBiz;
    /**
     * 公司人数
     */
	@TableField("company_person")
	private String companyPerson;
    /**
     * 年营业额
     */
	@TableField("year_turnover")
	private String yearTurnover;
    /**
     * 上传合同等必要的证明文件的扫描件图片地址
     */
	@TableField("verify_images")
	private String verifyImages;
    /**
     * 公司logo
     */
	private String logo;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;

	/**
	 * 联系人
	 */
	private String linkmen;
	/**
	 * 联系方式
	 */
	private String contact;


	public Long getId() {
		return id;
	}

	public FbUserAgent setId(Long id) {
		this.id = id;
		return this;
	}

	public Integer getoAgentD() {
		return oAgentD;
	}

	public FbUserAgent setoAgentD(Integer oAgentD) {
		this.oAgentD = oAgentD;
		return this;
	}

	public Long getAgentId() {
		return agentId;
	}

	public FbUserAgent setAgentId(Long agentId) {
		this.agentId = agentId;
		return this;
	}

	public Long getBaseId() {
		return baseId;
	}

	public FbUserAgent setBaseId(Long baseId) {
		this.baseId = baseId;
		return this;
	}

	public Long getOemId() {
		return oemId;
	}

	public FbUserAgent setOemId(Long oemId) {
		this.oemId = oemId;
		return this;
	}

	public Integer getAgentFee() {
		return agentFee;
	}

	public FbUserAgent setAgentFee(Integer agentFee) {
		this.agentFee = agentFee;
		return this;
	}

	public Long getBelong() {
		return belong;
	}

	public FbUserAgent setBelong(Long belong) {
		this.belong = belong;
		return this;
	}

	public Integer getLevel() {
		return level;
	}

	public FbUserAgent setLevel(Integer level) {
		this.level = level;
		return this;
	}

	public Integer getIsSelfSupport() {
		return isSelfSupport;
	}

	public FbUserAgent setIsSelfSupport(Integer isSelfSupport) {
		this.isSelfSupport = isSelfSupport;
		return this;
	}

	public Long getVipTime() {
		return vipTime;
	}

	public FbUserAgent setVipTime(Long vipTime) {
		this.vipTime = vipTime;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public FbUserAgent setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public Integer getCheckStatus() {
		return checkStatus;
	}

	public FbUserAgent setCheckStatus(Integer checkStatus) {
		this.checkStatus = checkStatus;
		return this;
	}

	public Long getCheckTime() {
		return checkTime;
	}

	public FbUserAgent setCheckTime(Long checkTime) {
		this.checkTime = checkTime;
		return this;
	}

	public String getRemark() {
		return remark;
	}

	public FbUserAgent setRemark(String remark) {
		this.remark = remark;
		return this;
	}

	public String getCompany() {
		return company;
	}

	public FbUserAgent setCompany(String company) {
		this.company = company;
		return this;
	}

	public String getAgentProvinceCode() {
		return agentProvinceCode;
	}

	public FbUserAgent setAgentProvinceCode(String agentProvinceCode) {
		this.agentProvinceCode = agentProvinceCode;
		return this;
	}

	public String getAgentProvinceName() {
		return agentProvinceName;
	}

	public FbUserAgent setAgentProvinceName(String agentProvinceName) {
		this.agentProvinceName = agentProvinceName;
		return this;
	}

	public String getAgentCityCode() {
		return agentCityCode;
	}

	public FbUserAgent setAgentCityCode(String agentCityCode) {
		this.agentCityCode = agentCityCode;
		return this;
	}

	public String getAgentCityName() {
		return agentCityName;
	}

	public FbUserAgent setAgentCityName(String agentCityName) {
		this.agentCityName = agentCityName;
		return this;
	}

	public String getAgentAreaCode() {
		return agentAreaCode;
	}

	public FbUserAgent setAgentAreaCode(String agentAreaCode) {
		this.agentAreaCode = agentAreaCode;
		return this;
	}

	public String getAgentAreaName() {
		return agentAreaName;
	}

	public FbUserAgent setAgentAreaName(String agentAreaName) {
		this.agentAreaName = agentAreaName;
		return this;
	}

	public String getIndustry() {
		return industry;
	}

	public FbUserAgent setIndustry(String industry) {
		this.industry = industry;
		return this;
	}

	public String getMainBiz() {
		return mainBiz;
	}

	public FbUserAgent setMainBiz(String mainBiz) {
		this.mainBiz = mainBiz;
		return this;
	}

	public String getCompanyPerson() {
		return companyPerson;
	}

	public FbUserAgent setCompanyPerson(String companyPerson) {
		this.companyPerson = companyPerson;
		return this;
	}

	public String getYearTurnover() {
		return yearTurnover;
	}

	public FbUserAgent setYearTurnover(String yearTurnover) {
		this.yearTurnover = yearTurnover;
		return this;
	}

	public String getVerifyImages() {
		return verifyImages;
	}

	public FbUserAgent setVerifyImages(String verifyImages) {
		this.verifyImages = verifyImages;
		return this;
	}

	public String getLogo() {
		return logo;
	}

	public FbUserAgent setLogo(String logo) {
		this.logo = logo;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbUserAgent setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbUserAgent setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}


	public String getLinkmen() {
		return linkmen;
	}

	public FbUserAgent setLinkmen(String linkmen) {
		this.linkmen = linkmen;
		return this;
	}

	public String getContact() {
		return contact;
	}

	public FbUserAgent setContact(String contact) {
		this.contact = contact;
		return this;
	}

	public static final String ID = "id";

	public static final String O_AGENT_D = "o_agent_d";

	public static final String AGENT_ID = "agent_id";

	public static final String BASE_ID = "base_id";

	public static final String OEM_ID = "oem_id";

	public static final String AGENT_FEE = "agent_fee";

	public static final String BELONG = "belong";

	public static final String LEVEL = "level";

	public static final String IS_SELF_SUPPORT = "is_self_support";

	public static final String VIP_TIME = "vip_time";

	public static final String STATUS = "status";

	public static final String CHECK_STATUS = "check_status";

	public static final String CHECK_TIME = "check_time";

	public static final String REMARK = "remark";

	public static final String COMPANY = "company";

	public static final String AGENT_PROVINCE_CODE = "agent_province_code";

	public static final String AGENT_PROVINCE_NAME = "agent_province_name";

	public static final String AGENT_CITY_CODE = "agent_city_code";

	public static final String AGENT_CITY_NAME = "agent_city_name";

	public static final String AGENT_AREA_CODE = "agent_area_code";

	public static final String AGENT_AREA_NAME = "agent_area_name";

	public static final String INDUSTRY = "industry";

	public static final String MAIN_BIZ = "main_biz";

	public static final String COMPANY_PERSON = "company_person";

	public static final String YEAR_TURNOVER = "year_turnover";

	public static final String VERIFY_IMAGES = "verify_images";

	public static final String LOGO = "logo";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	public static final String LINKMEN = "linkmen";

	public static final String CONTACT = "contact";

	@Override
	public String toString() {
		return "FbUserAgent{" +
			", id=" + id +
			", oAgentD=" + oAgentD +
			", agentId=" + agentId +
			", baseId=" + baseId +
			", oemId=" + oemId +
			", agentFee=" + agentFee +
			", belong=" + belong +
			", level=" + level +
			", isSelfSupport=" + isSelfSupport +
			", vipTime=" + vipTime +
			", status=" + status +
			", checkStatus=" + checkStatus +
			", checkTime=" + checkTime +
			", remark=" + remark +
			", company=" + company +
			", agentProvinceCode=" + agentProvinceCode +
			", agentProvinceName=" + agentProvinceName +
			", agentCityCode=" + agentCityCode +
			", agentCityName=" + agentCityName +
			", agentAreaCode=" + agentAreaCode +
			", agentAreaName=" + agentAreaName +
			", industry=" + industry +
			", mainBiz=" + mainBiz +
			", companyPerson=" + companyPerson +
			", yearTurnover=" + yearTurnover +
			", verifyImages=" + verifyImages +
			", logo=" + logo +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
