package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableLogic;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 商户入驻信息
 * </p>
 *
 * @author BuHao
 * @since 2018-01-15
 */
@TableName("fb_merchant_settle")
public class FbMerchantSettle implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
	@TableId(value="id", type= IdType.AUTO)
	private Long id;
    /**
     * 入驻唯一ID
     */
	@TableField("settle_id")
	private Boolean settleId;
    /**
     * 商户ID
     */
	private Long mid;
    /**
     * 入驻渠道 1支付宝 2微信
     */
	@TableField("settle_channel")
	private Integer settleChannel;
    /**
     * 是否入驻成功 1：是 0：否
     */
	private Integer status;
    /**
     * 入驻请求的信息（json）
     */
	@TableField("request_data")
	private String requestData;
    /**
     * 商户入驻接口返回信息
     */
	private String msg;
    /**
     * 是否删除 0否 1是
     */
	@TableField("is_del")
    @TableLogic
	private Integer isDel;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Long getId() {
		return id;
	}

	public FbMerchantSettle setId(Long id) {
		this.id = id;
		return this;
	}

	public Boolean getSettleId() {
		return settleId;
	}

	public FbMerchantSettle setSettleId(Boolean settleId) {
		this.settleId = settleId;
		return this;
	}

	public Long getMid() {
		return mid;
	}

	public FbMerchantSettle setMid(Long mid) {
		this.mid = mid;
		return this;
	}

	public Integer getSettleChannel() {
		return settleChannel;
	}

	public FbMerchantSettle setSettleChannel(Integer settleChannel) {
		this.settleChannel = settleChannel;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public FbMerchantSettle setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public String getRequestData() {
		return requestData;
	}

	public FbMerchantSettle setRequestData(String requestData) {
		this.requestData = requestData;
		return this;
	}

	public String getMsg() {
		return msg;
	}

	public FbMerchantSettle setMsg(String msg) {
		this.msg = msg;
		return this;
	}

	public Integer getIsDel() {
		return isDel;
	}

	public FbMerchantSettle setIsDel(Integer isDel) {
		this.isDel = isDel;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbMerchantSettle setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbMerchantSettle setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String SETTLE_ID = "settle_id";

	public static final String MID = "mid";

	public static final String SETTLE_CHANNEL = "settle_channel";

	public static final String STATUS = "status";

	public static final String REQUEST_DATA = "request_data";

	public static final String MSG = "msg";

	public static final String IS_DEL = "is_del";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbMerchantSettle{" +
			", id=" + id +
			", settleId=" + settleId +
			", mid=" + mid +
			", settleChannel=" + settleChannel +
			", status=" + status +
			", requestData=" + requestData +
			", msg=" + msg +
			", isDel=" + isDel +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
