package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 商户实名认证信息
 * </p>
 *
 * @author BuHao
 * @since 2018-01-15
 */
@TableName("fb_merchant_authentication")
public class FbMerchantAuthentication implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
	@TableId(value="id", type= IdType.AUTO)
	private Long id;
    /**
     * 实名认证ID
     */
	@TableField("auth_id")
	private Long authId;
    /**
     * 商户ID
     */
	private Long mid;
    /**
     * 身份证姓名
     */
	private String idname;
    /**
     * 身份证号
     */
	private String idcard;
    /**
     * 身份证照片
     */
	private String idcardphoto;
    /**
     * 营业执照编号
     */
	private String licenseid;
    /**
     * 营业执照名称（公司名称）
     */
	private String licensename;
    /**
     * 营业执照图片
     */
	private String licensephoto;
    /**
     * 企业法人姓名
     */
	@TableField("legal_person")
	private String legalPerson;
    /**
     * 法人身份证号码
     */
	@TableField("legal_idcard")
	private String legalIdcard;
    /**
     * 法人身份证图片
     */
	@TableField("legal_idphoto")
	private String legalIdphoto;
    /**
     * 实名认证时间戳
     */
	@TableField("auth_time")
	private Long authTime;
    /**
     * 0未认证，1认证中/待认证，2认证成功，3认证失败
     */
	@TableField("auth_status")
	private Integer authStatus;
    /**
     * 0未审核，1审核中/待审核，2审核通过，3审核失败
     */
	@TableField("verify_status")
	private Integer verifyStatus;
    /**
     * 客服审核处理时间
     */
	@TableField("handle_time")
	private Integer handleTime;
    /**
     * 客服拒绝以后填写理由
     */
	@TableField("reject_reason")
	private String rejectReason;
    /**
     * 1：个人用户；2：企业
     */
	private Integer type;
    /**
     * 实名认证审核方式 0人工审核 1接口审核
     */
	@TableField("examine_type")
	private Integer examineType;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Long getId() {
		return id;
	}

	public FbMerchantAuthentication setId(Long id) {
		this.id = id;
		return this;
	}

	public Long getAuthId() {
		return authId;
	}

	public FbMerchantAuthentication setAuthId(Long authId) {
		this.authId = authId;
		return this;
	}

	public Long getMid() {
		return mid;
	}

	public FbMerchantAuthentication setMid(Long mid) {
		this.mid = mid;
		return this;
	}

	public String getIdname() {
		return idname;
	}

	public FbMerchantAuthentication setIdname(String idname) {
		this.idname = idname;
		return this;
	}

	public String getIdcard() {
		return idcard;
	}

	public FbMerchantAuthentication setIdcard(String idcard) {
		this.idcard = idcard;
		return this;
	}

	public String getIdcardphoto() {
		return idcardphoto;
	}

	public FbMerchantAuthentication setIdcardphoto(String idcardphoto) {
		this.idcardphoto = idcardphoto;
		return this;
	}

	public String getLicenseid() {
		return licenseid;
	}

	public FbMerchantAuthentication setLicenseid(String licenseid) {
		this.licenseid = licenseid;
		return this;
	}

	public String getLicensename() {
		return licensename;
	}

	public FbMerchantAuthentication setLicensename(String licensename) {
		this.licensename = licensename;
		return this;
	}

	public String getLicensephoto() {
		return licensephoto;
	}

	public FbMerchantAuthentication setLicensephoto(String licensephoto) {
		this.licensephoto = licensephoto;
		return this;
	}

	public String getLegalPerson() {
		return legalPerson;
	}

	public FbMerchantAuthentication setLegalPerson(String legalPerson) {
		this.legalPerson = legalPerson;
		return this;
	}

	public String getLegalIdcard() {
		return legalIdcard;
	}

	public FbMerchantAuthentication setLegalIdcard(String legalIdcard) {
		this.legalIdcard = legalIdcard;
		return this;
	}

	public String getLegalIdphoto() {
		return legalIdphoto;
	}

	public FbMerchantAuthentication setLegalIdphoto(String legalIdphoto) {
		this.legalIdphoto = legalIdphoto;
		return this;
	}

	public Long getAuthTime() {
		return authTime;
	}

	public FbMerchantAuthentication setAuthTime(Long authTime) {
		this.authTime = authTime;
		return this;
	}

	public Integer getAuthStatus() {
		return authStatus;
	}

	public FbMerchantAuthentication setAuthStatus(Integer authStatus) {
		this.authStatus = authStatus;
		return this;
	}

	public Integer getVerifyStatus() {
		return verifyStatus;
	}

	public FbMerchantAuthentication setVerifyStatus(Integer verifyStatus) {
		this.verifyStatus = verifyStatus;
		return this;
	}

	public Integer getHandleTime() {
		return handleTime;
	}

	public FbMerchantAuthentication setHandleTime(Integer handleTime) {
		this.handleTime = handleTime;
		return this;
	}

	public String getRejectReason() {
		return rejectReason;
	}

	public FbMerchantAuthentication setRejectReason(String rejectReason) {
		this.rejectReason = rejectReason;
		return this;
	}

	public Integer getType() {
		return type;
	}

	public FbMerchantAuthentication setType(Integer type) {
		this.type = type;
		return this;
	}

	public Integer getExamineType() {
		return examineType;
	}

	public FbMerchantAuthentication setExamineType(Integer examineType) {
		this.examineType = examineType;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbMerchantAuthentication setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbMerchantAuthentication setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String AUTH_ID = "auth_id";

	public static final String MID = "mid";

	public static final String IDNAME = "idname";

	public static final String IDCARD = "idcard";

	public static final String IDCARDPHOTO = "idcardphoto";

	public static final String LICENSEID = "licenseid";

	public static final String LICENSENAME = "licensename";

	public static final String LICENSEPHOTO = "licensephoto";

	public static final String LEGAL_PERSON = "legal_person";

	public static final String LEGAL_IDCARD = "legal_idcard";

	public static final String LEGAL_IDPHOTO = "legal_idphoto";

	public static final String AUTH_TIME = "auth_time";

	public static final String AUTH_STATUS = "auth_status";

	public static final String VERIFY_STATUS = "verify_status";

	public static final String HANDLE_TIME = "handle_time";

	public static final String REJECT_REASON = "reject_reason";

	public static final String TYPE = "type";

	public static final String EXAMINE_TYPE = "examine_type";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbMerchantAuthentication{" +
			", id=" + id +
			", authId=" + authId +
			", mid=" + mid +
			", idname=" + idname +
			", idcard=" + idcard +
			", idcardphoto=" + idcardphoto +
			", licenseid=" + licenseid +
			", licensename=" + licensename +
			", licensephoto=" + licensephoto +
			", legalPerson=" + legalPerson +
			", legalIdcard=" + legalIdcard +
			", legalIdphoto=" + legalIdphoto +
			", authTime=" + authTime +
			", authStatus=" + authStatus +
			", verifyStatus=" + verifyStatus +
			", handleTime=" + handleTime +
			", rejectReason=" + rejectReason +
			", type=" + type +
			", examineType=" + examineType +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
