package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 绑卡记录
 * </p>
 *
 * @author BuHao
 * @since 2018-01-12
 */
@TableName("fb_bank_bind_record")
public class FbBankBindRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
	@TableId(value="id", type= IdType.AUTO)
	private Integer id;
    /**
     * 商户唯一id
     */
	private Long mid;
    /**
     * 银行卡号
     */
	@TableField("card_no")
	private String cardNo;
    /**
     * 银行唯一ID
     */
	@TableField("bank_id")
	private Long bankId;
    /**
     * 银行名称
     */
	@TableField("bank_name")
	private String bankName;
    /**
     * 绑卡状态 1成功 0失败
     */
	@TableField("bind_status")
	private Integer bindStatus;
    /**
     * 绑卡信息
     */
	private String msg;
    /**
     * 绑卡时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Integer getId() {
		return id;
	}

	public FbBankBindRecord setId(Integer id) {
		this.id = id;
		return this;
	}

	public Long getMid() {
		return mid;
	}

	public FbBankBindRecord setMid(Long mid) {
		this.mid = mid;
		return this;
	}

	public String getCardNo() {
		return cardNo;
	}

	public FbBankBindRecord setCardNo(String cardNo) {
		this.cardNo = cardNo;
		return this;
	}

	public Long getBankId() {
		return bankId;
	}

	public FbBankBindRecord setBankId(Long bankId) {
		this.bankId = bankId;
		return this;
	}

	public String getBankName() {
		return bankName;
	}

	public FbBankBindRecord setBankName(String bankName) {
		this.bankName = bankName;
		return this;
	}

	public Integer getBindStatus() {
		return bindStatus;
	}

	public FbBankBindRecord setBindStatus(Integer bindStatus) {
		this.bindStatus = bindStatus;
		return this;
	}

	public String getMsg() {
		return msg;
	}

	public FbBankBindRecord setMsg(String msg) {
		this.msg = msg;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbBankBindRecord setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbBankBindRecord setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String MID = "mid";

	public static final String CARD_NO = "card_no";

	public static final String BANK_ID = "bank_id";

	public static final String BANK_NAME = "bank_name";

	public static final String BIND_STATUS = "bind_status";

	public static final String MSG = "msg";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbBankBindRecord{" +
			", id=" + id +
			", mid=" + mid +
			", cardNo=" + cardNo +
			", bankId=" + bankId +
			", bankName=" + bankName +
			", bindStatus=" + bindStatus +
			", msg=" + msg +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
