package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableLogic;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 商户子账户信息表
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
@TableName("fb_user_merchant_children")
public class FbUserMerchantChildren implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
	@TableId(value="id", type= IdType.AUTO)
	private Long id;
    /**
     * 商户ID
     */
	private Long mid;
    /**
     * 基础用户ID
     */
	@TableField("base_id")
	private Long baseId;
    /**
     * 门店ID
     */
	@TableField("store_id")
	private Long storeId;

	/**
	 * 角色ID
	 */
	@TableField("role_id")
	private Long roleId;
    /**
     * 角色名称
     */
	private String name;
    /**
     * 备注
     */
	private String remark;



    /**
     * 是否激活 1：是 0：否
     */
	private Integer status;
    /**
     * 是否删除 0否 1是
     */
	@TableField("is_del")
    @TableLogic
	private Integer isDel;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Long getId() {
		return id;
	}

	public FbUserMerchantChildren setId(Long id) {
		this.id = id;
		return this;
	}

	public Long getMid() {
		return mid;
	}

	public FbUserMerchantChildren setMid(Long mid) {
		this.mid = mid;
		return this;
	}

	public Long getBaseId() {
		return baseId;
	}

	public FbUserMerchantChildren setBaseId(Long baseId) {
		this.baseId = baseId;
		return this;
	}

	public Long getStoreId() {
		return storeId;
	}

	public FbUserMerchantChildren setStoreId(Long storeId) {
		this.storeId = storeId;
		return this;
	}

	public String getName() {
		return name;
	}

	public FbUserMerchantChildren setName(String name) {
		this.name = name;
		return this;
	}

	public String getRemark() {
		return remark;
	}

	public FbUserMerchantChildren setRemark(String remark) {
		this.remark = remark;
		return this;
	}

	public Long getRoleId() {
		return roleId;
	}

	public FbUserMerchantChildren setRoleId(Long roleId) {
		this.roleId = roleId;
		return this;
	}




	public Integer getStatus() {
		return status;
	}

	public FbUserMerchantChildren setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public Integer getIsDel() {
		return isDel;
	}

	public FbUserMerchantChildren setIsDel(Integer isDel) {
		this.isDel = isDel;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbUserMerchantChildren setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbUserMerchantChildren setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String MID = "mid";

	public static final String ROLE_ID = "role_id";

	public static final String BASE_ID = "base_id";

	public static final String STORE_ID = "store_id";

	public static final String NAME = "name";

	public static final String REMARK = "remark";

	public static final String ACCESS_LIST = "access_list";

	public static final String STATUS = "status";

	public static final String IS_DEL = "is_del";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";



	@Override
	public String toString() {
		return "FbUserMerchantChildren{" +
			", id=" + id +
			", mid=" + mid +
			", baseId=" + baseId +
			", storeId=" + storeId +
			", name=" + name +
			", remark=" + remark +
			", roleId=" + roleId +
			", status=" + status +
			", isDel=" + isDel +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
