package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 商户子账户角色权限配置信息
 * </p>
 *
 * @author BuHao
 * @since 2018-01-03
 */
@TableName("fb_merchant_children_role_right_control")
public class FbMerchantChildrenRoleRightControl implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
	@TableId(value="id", type= IdType.AUTO)
	private Long id;
    /**
     * 商户子账户角色id
     */
	@TableField("role_id")
	private Long roleId;
    /**
     * 权限点
     */
	@TableField("right_key")
	private String rightKey;
    /**
     * 是否开启 O:不开启；1:开启
     */
	@TableField("is_open")
	private Integer isOpen;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Long getId() {
		return id;
	}

	public FbMerchantChildrenRoleRightControl setId(Long id) {
		this.id = id;
		return this;
	}

	public Long getRoleId() {
		return roleId;
	}

	public FbMerchantChildrenRoleRightControl setRoleId(Long roleId) {
		this.roleId = roleId;
		return this;
	}

	public String getRightKey() {
		return rightKey;
	}

	public FbMerchantChildrenRoleRightControl setRightKey(String rightKey) {
		this.rightKey = rightKey;
		return this;
	}

	public Integer getIsOpen() {
		return isOpen;
	}

	public FbMerchantChildrenRoleRightControl setIsOpen(Integer isOpen) {
		this.isOpen = isOpen;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbMerchantChildrenRoleRightControl setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbMerchantChildrenRoleRightControl setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String ROLE_ID = "role_id";

	public static final String RIGHT_KEY = "right_key";

	public static final String IS_OPEN = "is_open";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbMerchantChildrenRoleRightControl{" +
			", id=" + id +
			", roleId=" + roleId +
			", rightKey=" + rightKey +
			", isOpen=" + isOpen +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
