package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * OEM商信息
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
@TableName("fb_user_oem")
public class FbUserOem implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
	@TableId(value="id", type= IdType.AUTO)
	private Long id;
    /**
     * 旧系统OEM商ID
     */
	@TableField("o_oem_id")
	private Integer oOemId;
    /**
     * OEM_ID
     */
	@TableField("oem_id")
	private Long oemId;
    /**
     * 基础用户ID
     */
	@TableField("base_id")
	private Long baseId;
    /**
     * 是否自营 1是 0否
     */
	@TableField("is_self_support")
	private Integer isSelfSupport;
    /**
     * 总后台名称
     */
	@TableField("admin_title")
	private String adminTitle;
    /**
     * 品牌简称
     */
	@TableField("brand_name")
	private String brandName;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Long getId() {
		return id;
	}

	public FbUserOem setId(Long id) {
		this.id = id;
		return this;
	}

	public Integer getoOemId() {
		return oOemId;
	}

	public FbUserOem setoOemId(Integer oOemId) {
		this.oOemId = oOemId;
		return this;
	}

	public Long getOemId() {
		return oemId;
	}

	public FbUserOem setOemId(Long oemId) {
		this.oemId = oemId;
		return this;
	}

	public Long getBaseId() {
		return baseId;
	}

	public FbUserOem setBaseId(Long baseId) {
		this.baseId = baseId;
		return this;
	}

	public Integer getIsSelfSupport() {
		return isSelfSupport;
	}

	public FbUserOem setIsSelfSupport(Integer isSelfSupport) {
		this.isSelfSupport = isSelfSupport;
		return this;
	}

	public String getAdminTitle() {
		return adminTitle;
	}

	public FbUserOem setAdminTitle(String adminTitle) {
		this.adminTitle = adminTitle;
		return this;
	}

	public String getBrandName() {
		return brandName;
	}

	public FbUserOem setBrandName(String brandName) {
		this.brandName = brandName;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbUserOem setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbUserOem setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String O_OEM_ID = "o_oem_id";

	public static final String OEM_ID = "oem_id";

	public static final String BASE_ID = "base_id";

	public static final String IS_SELF_SUPPORT = "is_self_support";

	public static final String ADMIN_TITLE = "admin_title";

	public static final String BRAND_NAME = "brand_name";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbUserOem{" +
			", id=" + id +
			", oOemId=" + oOemId +
			", oemId=" + oemId +
			", baseId=" + baseId +
			", isSelfSupport=" + isSelfSupport +
			", adminTitle=" + adminTitle +
			", brandName=" + brandName +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
