package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 操作日志表
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
@TableName("fb_operate_log")
public class FbOperateLog implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
	@TableId(value="id", type= IdType.AUTO)
	private Long id;
    /**
     * 用户id
     */
	@TableField("user_id")
	private Long userId;
    /**
     * 用户昵称
     */
	@TableField("user_nick")
	private String userNick;
    /**
     * 操作模块 1：oem管理；2：代理商管理；3：授理商管理；4：商户管理；
     */
	@TableField("operate_module")
	private Integer operateModule;
    /**
     * 操作内容
     */
	@TableField("operate_body")
	private String operateBody;
    /**
     * 操作类型 1：增加；2：修改；3：删除
     */
	private Integer type;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Long getId() {
		return id;
	}

	public FbOperateLog setId(Long id) {
		this.id = id;
		return this;
	}

	public Long getUserId() {
		return userId;
	}

	public FbOperateLog setUserId(Long userId) {
		this.userId = userId;
		return this;
	}

	public String getUserNick() {
		return userNick;
	}

	public FbOperateLog setUserNick(String userNick) {
		this.userNick = userNick;
		return this;
	}

	public Integer getOperateModule() {
		return operateModule;
	}

	public FbOperateLog setOperateModule(Integer operateModule) {
		this.operateModule = operateModule;
		return this;
	}

	public String getOperateBody() {
		return operateBody;
	}

	public FbOperateLog setOperateBody(String operateBody) {
		this.operateBody = operateBody;
		return this;
	}

	public Integer getType() {
		return type;
	}

	public FbOperateLog setType(Integer type) {
		this.type = type;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbOperateLog setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbOperateLog setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String USER_ID = "user_id";

	public static final String USER_NICK = "user_nick";

	public static final String OPERATE_MODULE = "operate_module";

	public static final String OPERATE_BODY = "operate_body";

	public static final String TYPE = "type";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbOperateLog{" +
			", id=" + id +
			", userId=" + userId +
			", userNick=" + userNick +
			", operateModule=" + operateModule +
			", operateBody=" + operateBody +
			", type=" + type +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
