package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableLogic;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 总后台功能菜单
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
@TableName("fb_oem_node")
public class FbOemNode implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
	@TableId(value="id", type= IdType.AUTO)
	private Long id;
    /**
     * 旧菜单节点ID
     */
	@TableField("o_node_id")
	private Integer oNodeId;
    /**
     * 节点ID
     */
	@TableField("node_id")
	private Long nodeId;
    /**
     * 操作（action）
     */
	private String action;
    /**
     * 菜单名称
     */
	private String title;
    /**
     * 显示类型 0隐藏  1显示
     */
	@TableField("is_display")
	private Integer isDisplay;
    /**
     * 备注说明
     */
	private String remark;
    /**
     * 父ID
     */
	private Long pid;
    /**
     * 节点等级
     */
	private Integer level;
    /**
     * 排序权重
     */
	private Integer sort;
    /**
     * 是否自营专属 1是 0否
     */
	@TableField("is_self_support")
	private Integer isSelfSupport;
    /**
     * 是否删除 0否 1是
     */
	@TableField("is_del")
    @TableLogic
	private Integer isDel;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Long getId() {
		return id;
	}

	public FbOemNode setId(Long id) {
		this.id = id;
		return this;
	}

	public Integer getoNodeId() {
		return oNodeId;
	}

	public FbOemNode setoNodeId(Integer oNodeId) {
		this.oNodeId = oNodeId;
		return this;
	}

	public Long getNodeId() {
		return nodeId;
	}

	public FbOemNode setNodeId(Long nodeId) {
		this.nodeId = nodeId;
		return this;
	}

	public String getAction() {
		return action;
	}

	public FbOemNode setAction(String action) {
		this.action = action;
		return this;
	}

	public String getTitle() {
		return title;
	}

	public FbOemNode setTitle(String title) {
		this.title = title;
		return this;
	}

	public Integer getIsDisplay() {
		return isDisplay;
	}

	public FbOemNode setIsDisplay(Integer isDisplay) {
		this.isDisplay = isDisplay;
		return this;
	}

	public String getRemark() {
		return remark;
	}

	public FbOemNode setRemark(String remark) {
		this.remark = remark;
		return this;
	}

	public Long getPid() {
		return pid;
	}

	public FbOemNode setPid(Long pid) {
		this.pid = pid;
		return this;
	}

	public Integer getLevel() {
		return level;
	}

	public FbOemNode setLevel(Integer level) {
		this.level = level;
		return this;
	}

	public Integer getSort() {
		return sort;
	}

	public FbOemNode setSort(Integer sort) {
		this.sort = sort;
		return this;
	}

	public Integer getIsSelfSupport() {
		return isSelfSupport;
	}

	public FbOemNode setIsSelfSupport(Integer isSelfSupport) {
		this.isSelfSupport = isSelfSupport;
		return this;
	}

	public Integer getIsDel() {
		return isDel;
	}

	public FbOemNode setIsDel(Integer isDel) {
		this.isDel = isDel;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbOemNode setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbOemNode setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String O_NODE_ID = "o_node_id";

	public static final String NODE_ID = "node_id";

	public static final String ACTION = "action";

	public static final String TITLE = "title";

	public static final String IS_DISPLAY = "is_display";

	public static final String REMARK = "remark";

	public static final String PID = "pid";

	public static final String LEVEL = "level";

	public static final String SORT = "sort";

	public static final String IS_SELF_SUPPORT = "is_self_support";

	public static final String IS_DEL = "is_del";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbOemNode{" +
			", id=" + id +
			", oNodeId=" + oNodeId +
			", nodeId=" + nodeId +
			", action=" + action +
			", title=" + title +
			", isDisplay=" + isDisplay +
			", remark=" + remark +
			", pid=" + pid +
			", level=" + level +
			", sort=" + sort +
			", isSelfSupport=" + isSelfSupport +
			", isDel=" + isDel +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
