package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 商户权限配置信息
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
@TableName("fb_merchant_right_control")
public class FbMerchantRightControl implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
	@TableId(value="id", type= IdType.AUTO)
	private Long id;
    /**
     * 商户的id
     */
	private Long mid;
    /**
     * 权限点
     */
	@TableField("right_key")
	private String rightKey;
    /**
     * 是否开启 O:不开启；1:开启
     */
	@TableField("is_open")
	private Integer isOpen;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Long getId() {
		return id;
	}

	public FbMerchantRightControl setId(Long id) {
		this.id = id;
		return this;
	}

	public Long getMid() {
		return mid;
	}

	public FbMerchantRightControl setMid(Long mid) {
		this.mid = mid;
		return this;
	}

	public String getRightKey() {
		return rightKey;
	}

	public FbMerchantRightControl setRightKey(String rightKey) {
		this.rightKey = rightKey;
		return this;
	}

	public Integer getIsOpen() {
		return isOpen;
	}

	public FbMerchantRightControl setIsOpen(Integer isOpen) {
		this.isOpen = isOpen;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbMerchantRightControl setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbMerchantRightControl setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String MID = "mid";

	public static final String RIGHT_KEY = "right_key";

	public static final String IS_OPEN = "is_open";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbMerchantRightControl{" +
			", id=" + id +
			", mid=" + mid +
			", rightKey=" + rightKey +
			", isOpen=" + isOpen +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
