package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 商户权限配置表
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
@TableName("fb_merchant_right_config")
public class FbMerchantRightConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
	@TableId(value="id", type= IdType.AUTO)
	private Long id;
    /**
     * 权限id
     */
	@TableField("right_id")
	private Long rightId;
    /**
     * 权限key 如：is_open_alipay
     */
	@TableField("right_key")
	private String rightKey;
    /**
     * 权限说明 如：支付宝支付权限
     */
	private String remark;
    /**
     * 功能权限状态 O:不启用；1:启用
     */
	private Integer status;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Long getId() {
		return id;
	}

	public FbMerchantRightConfig setId(Long id) {
		this.id = id;
		return this;
	}

	public Long getRightId() {
		return rightId;
	}

	public FbMerchantRightConfig setRightId(Long rightId) {
		this.rightId = rightId;
		return this;
	}

	public String getRightKey() {
		return rightKey;
	}

	public FbMerchantRightConfig setRightKey(String rightKey) {
		this.rightKey = rightKey;
		return this;
	}

	public String getRemark() {
		return remark;
	}

	public FbMerchantRightConfig setRemark(String remark) {
		this.remark = remark;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public FbMerchantRightConfig setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbMerchantRightConfig setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbMerchantRightConfig setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String RIGHT_ID = "right_id";

	public static final String RIGHT_KEY = "right_key";

	public static final String REMARK = "remark";

	public static final String STATUS = "status";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbMerchantRightConfig{" +
			", id=" + id +
			", rightId=" + rightId +
			", rightKey=" + rightKey +
			", remark=" + remark +
			", status=" + status +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
