package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableLogic;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * OEM商子账户信息表
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
@TableName("fb_user_oem_children")
public class FbUserOemChildren implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
	@TableId(value="id", type= IdType.AUTO)
	private Long id;
    /**
     * OEM商ID
     */
	@TableField("oem_id")
	private Long oemId;
    /**
     * 基础用户ID
     */
	@TableField("base_id")
	private Long baseId;
    /**
     * 角色ID
     */
	@TableField("role_id")
	private Long roleId;
    /**
     * 联系人
     */
	private String linkman;
    /**
     * 是否删除 0否 1是
     */
	@TableField("is_del")
    @TableLogic
	private Integer isDel;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Long getId() {
		return id;
	}

	public FbUserOemChildren setId(Long id) {
		this.id = id;
		return this;
	}

	public Long getOemId() {
		return oemId;
	}

	public FbUserOemChildren setOemId(Long oemId) {
		this.oemId = oemId;
		return this;
	}

	public Long getBaseId() {
		return baseId;
	}

	public FbUserOemChildren setBaseId(Long baseId) {
		this.baseId = baseId;
		return this;
	}

	public Long getRoleId() {
		return roleId;
	}

	public FbUserOemChildren setRoleId(Long roleId) {
		this.roleId = roleId;
		return this;
	}

	public String getLinkman() {
		return linkman;
	}

	public FbUserOemChildren setLinkman(String linkman) {
		this.linkman = linkman;
		return this;
	}

	public Integer getIsDel() {
		return isDel;
	}

	public FbUserOemChildren setIsDel(Integer isDel) {
		this.isDel = isDel;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbUserOemChildren setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbUserOemChildren setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String OEM_ID = "oem_id";

	public static final String BASE_ID = "base_id";

	public static final String ROLE_ID = "role_id";

	public static final String LINKMAN = "linkman";

	public static final String IS_DEL = "is_del";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbUserOemChildren{" +
			", id=" + id +
			", oemId=" + oemId +
			", baseId=" + baseId +
			", roleId=" + roleId +
			", linkman=" + linkman +
			", isDel=" + isDel +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
