package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * OEM商权限配置信息
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
@TableName("fb_oem_right_control")
public class FbOemRightControl implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
	@TableId(value="id", type= IdType.AUTO)
	private Long id;
    /**
     * OEM商id
     */
	@TableField("oem_id")
	private Long oemId;
    /**
     * 是否开启T0权限 O:不开启；1:开启
     */
	@TableField("right_key")
	private String rightKey;
    /**
     * 是否开启
     */
	@TableField("is_open")
	private Integer isOpen;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Long getId() {
		return id;
	}

	public FbOemRightControl setId(Long id) {
		this.id = id;
		return this;
	}

	public Long getOemId() {
		return oemId;
	}

	public FbOemRightControl setOemId(Long oemId) {
		this.oemId = oemId;
		return this;
	}

	public String getRightKey() {
		return rightKey;
	}

	public FbOemRightControl setRightKey(String rightKey) {
		this.rightKey = rightKey;
		return this;
	}

	public Integer getIsOpen() {
		return isOpen;
	}

	public FbOemRightControl setIsOpen(Integer isOpen) {
		this.isOpen = isOpen;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbOemRightControl setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbOemRightControl setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String OEM_ID = "oem_id";

	public static final String RIGHT_KEY = "right_key";

	public static final String IS_OPEN = "is_open";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbOemRightControl{" +
			", id=" + id +
			", oemId=" + oemId +
			", rightKey=" + rightKey +
			", isOpen=" + isOpen +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
