package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 代理商权限控制关系表
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
@TableName("fb_agent_right_control")
public class FbAgentRightControl implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
	@TableId(value="id", type= IdType.AUTO)
	private Long id;
    /**
     * 代理商的主键id
     */
	@TableField("agent_id")
	private Long agentId;
    /**
     * 权限点
     */
	@TableField("right_key")
	private String rightKey;
    /**
     * 是否开启 0:不开启；1:开启
     */
	@TableField("is_open")
	private Integer isOpen;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Long getId() {
		return id;
	}

	public FbAgentRightControl setId(Long id) {
		this.id = id;
		return this;
	}

	public Long getAgentId() {
		return agentId;
	}

	public FbAgentRightControl setAgentId(Long agentId) {
		this.agentId = agentId;
		return this;
	}

	public String getRightKey() {
		return rightKey;
	}

	public FbAgentRightControl setRightKey(String rightKey) {
		this.rightKey = rightKey;
		return this;
	}

	public Integer getIsOpen() {
		return isOpen;
	}

	public FbAgentRightControl setIsOpen(Integer isOpen) {
		this.isOpen = isOpen;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbAgentRightControl setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbAgentRightControl setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String AGENT_ID = "agent_id";

	public static final String RIGHT_KEY = "right_key";

	public static final String IS_OPEN = "is_open";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbAgentRightControl{" +
			", id=" + id +
			", agentId=" + agentId +
			", rightKey=" + rightKey +
			", isOpen=" + isOpen +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
