package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableLogic;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 总后台管理员组
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
@TableName("fb_oem_role")
public class FbOemRole implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
	@TableId(value="id", type= IdType.AUTO)
	private Long id;
    /**
     * 角色ID
     */
	@TableField("role_id")
	private Long roleId;
    /**
     * OEM商ID
     */
	@TableField("oem_id")
	private Long oemId;
    /**
     * 管理组名
     */
	private String name;
    /**
     * 管理组状态是否激活 1：是 0：否
     */
	private Integer status;
    /**
     * 备注说明
     */
	private String remark;
    /**
     * 是否删除 0否 1是
     */
	@TableField("is_del")
    @TableLogic
	private Integer isDel;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Long getId() {
		return id;
	}

	public FbOemRole setId(Long id) {
		this.id = id;
		return this;
	}

	public Long getRoleId() {
		return roleId;
	}

	public FbOemRole setRoleId(Long roleId) {
		this.roleId = roleId;
		return this;
	}

	public Long getOemId() {
		return oemId;
	}

	public FbOemRole setOemId(Long oemId) {
		this.oemId = oemId;
		return this;
	}

	public String getName() {
		return name;
	}

	public FbOemRole setName(String name) {
		this.name = name;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public FbOemRole setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public String getRemark() {
		return remark;
	}

	public FbOemRole setRemark(String remark) {
		this.remark = remark;
		return this;
	}

	public Integer getIsDel() {
		return isDel;
	}

	public FbOemRole setIsDel(Integer isDel) {
		this.isDel = isDel;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbOemRole setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbOemRole setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String ROLE_ID = "role_id";

	public static final String OEM_ID = "oem_id";

	public static final String NAME = "name";

	public static final String STATUS = "status";

	public static final String REMARK = "remark";

	public static final String IS_DEL = "is_del";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbOemRole{" +
			", id=" + id +
			", roleId=" + roleId +
			", oemId=" + oemId +
			", name=" + name +
			", status=" + status +
			", remark=" + remark +
			", isDel=" + isDel +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
