package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableLogic;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * OEM商功能菜单关系
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
@TableName("fb_oem_node_right")
public class FbOemNodeRight implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
	@TableId(value="id", type= IdType.AUTO)
	private Long id;
    /**
     * OEM_ID
     */
	@TableField("oem_id")
	private Long oemId;
    /**
     * 节点ID
     */
	@TableField("node_id")
	private Long nodeId;
    /**
     * 是否删除 0否 1是
     */
	@TableField("is_del")
    @TableLogic
	private Integer isDel;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Long getId() {
		return id;
	}

	public FbOemNodeRight setId(Long id) {
		this.id = id;
		return this;
	}

	public Long getOemId() {
		return oemId;
	}

	public FbOemNodeRight setOemId(Long oemId) {
		this.oemId = oemId;
		return this;
	}

	public Long getNodeId() {
		return nodeId;
	}

	public FbOemNodeRight setNodeId(Long nodeId) {
		this.nodeId = nodeId;
		return this;
	}

	public Integer getIsDel() {
		return isDel;
	}

	public FbOemNodeRight setIsDel(Integer isDel) {
		this.isDel = isDel;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbOemNodeRight setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbOemNodeRight setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String OEM_ID = "oem_id";

	public static final String NODE_ID = "node_id";

	public static final String IS_DEL = "is_del";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbOemNodeRight{" +
			", id=" + id +
			", oemId=" + oemId +
			", nodeId=" + nodeId +
			", isDel=" + isDel +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
