package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * OEM配置信息
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
@TableName("fb_oem_config")
public class FbOemConfig implements Serializable {

    private static final long serialVersionUID = 1L;

	@TableId(value="id", type= IdType.AUTO)
	private Long id;
    /**
     * OEM商ID
     */
	@TableField("oem_id")
	private Long oemId;
    /**
     * 总后台logo cleanImgUrl
     */
	@TableField("admin_logo")
	private String adminLogo;
    /**
     * 首页欢迎语
     */
	@TableField("welcome_word")
	private String welcomeWord;
    /**
     * 附属总后台登录页url
     */
	@TableField("admin_url")
	private String adminUrl;
    /**
     * 代理商后台logo cleanImgUrl
     */
	@TableField("agent_logo")
	private String agentLogo;
    /**
     * 代理商后台登陆url
     */
	@TableField("agent_url")
	private String agentUrl;
    /**
     * 商户后台logo cleanImgUrl
     */
	@TableField("user_logo")
	private String userLogo;
    /**
     * 商户后台登陆url
     */
	@TableField("user_url")
	private String userUrl;
    /**
     * 网页顶部文案（服务热线）
     */
	@TableField("top_msg")
	private String topMsg;
    /**
     * 网页底部文案
     */
	@TableField("bottom_msg")
	private String bottomMsg;
    /**
     * 收款语音和文字提示
     */
	@TableField("voice_remind")
	private String voiceRemind;
    /**
     * 语音开关 1关 0开
     */
	@TableField("voice_on_off")
	private Integer voiceOnOff;
    /**
     * 绑卡协议 1 生活圈  2杉德
     */
	@TableField("bind_protocol")
	private Integer bindProtocol;
    /**
     * 视频是否显示  1隐藏 0显示
     */
	@TableField("video_on_off")
	private Integer videoOnOff;
    /**
     * 红包文案
     */
	@TableField("red_packet_notice")
	private String redPacketNotice;
    /**
     * 红包内容文案
     */
	@TableField("red_packet_msg")
	private String redPacketMsg;
    /**
     * 附属总后台url结尾域名
     */
	@TableField("sub_domain")
	private String subDomain;
    /**
     * 总后台登录背景
     */
	@TableField("admin_login_bg")
	private String adminLoginBg;
    /**
     * 总后台登录logo
     */
	@TableField("admin_login_logo")
	private String adminLoginLogo;
    /**
     * 总后台登录文案
     */
	@TableField("admin_login_title")
	private String adminLoginTitle;
    /**
     * 代理商登录背景
     */
	@TableField("agent_login_bg")
	private String agentLoginBg;
    /**
     * 代理商登录页Logo
     */
	@TableField("agent_login_logo")
	private String agentLoginLogo;
    /**
     * 代理商登录页标题
     */
	@TableField("agent_login_title")
	private String agentLoginTitle;
    /**
     * 商户登录背景
     */
	@TableField("user_login_bg")
	private String userLoginBg;
    /**
     * 商户登录页Logo
     */
	@TableField("user_login_logo")
	private String userLoginLogo;
    /**
     * 商户登录页标题
     */
	@TableField("user_login_title")
	private String userLoginTitle;
    /**
     * 公众号
     */
	@TableField("wx_official_account")
	private String wxOfficialAccount;
    /**
     * 门店二维码背景图
     */
	@TableField("qrcode_background")
	private String qrcodeBackground;
    /**
     * 朋友圈广告投放联系方式
     */
	@TableField("agent_ad_text")
	private String agentAdText;
    /**
     * h5页面首页标题
     */
	@TableField("wap_index_title")
	private String wapIndexTitle;
    /**
     * H5页面商家会员的默认头像
     */
	@TableField("wap_default_header")
	private String wapDefaultHeader;
    /**
     * H5顾客默认昵称
     */
	@TableField("wap_default_nickname")
	private String wapDefaultNickname;
    /**
     * H5页面顾客默认头像
     */
	@TableField("wap_user_header")
	private String wapUserHeader;
    /**
     * 绑卡协议标题
     */
	@TableField("protocol_title")
	private String protocolTitle;
    /**
     * 绑卡协议内容
     */
	@TableField("protocol_content")
	private String protocolContent;
    /**
     * 微信公众号AppID
     */
	@TableField("wx_mp_appid")
	private String wxMpAppid;
    /**
     * 微信公众号AppSecret
     */
	@TableField("wx_mp_appsecret")
	private String wxMpAppsecret;
    /**
     * 激品活会员验证码短信的品牌名
     */
	@TableField("wap_active_band")
	private String wapActiveBand;
    /**
     * 成为会员短信通知的品牌名
     */
	@TableField("wap_member_band")
	private String wapMemberBand;
    /**
     * 网站标题logo cleanImgUrl
     */
	@TableField("web_logo")
	private String webLogo;
    /**
     * app客服电话
     */
	@TableField("app_customer_mobile")
	private String appCustomerMobile;
    /**
     * app绑卡提示文案
     */
	@TableField("app_bind_text")
	private String appBindText;
    /**
     * 子商户号Id
     */
	@TableField("config_type")
	private Integer configType;
    /**
     * 是否展示商户协议 1展示 0不展示
     */
	@TableField("is_show_protocol")
	private Integer isShowProtocol;
    /**
     * 订单支付成功通知
     */
	@TableField("pay_success_notice")
	private String paySuccessNotice;
    /**
     * 二维码海报文案
     */
	@TableField("qr_code_url")
	private String qrCodeUrl;
    /**
     * 海报文案
     */
	@TableField("post_document")
	private String postDocument;
    /**
     * 海报背景
     */
	@TableField("post_logo")
	private String postLogo;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Long getId() {
		return id;
	}

	public FbOemConfig setId(Long id) {
		this.id = id;
		return this;
	}

	public Long getOemId() {
		return oemId;
	}

	public FbOemConfig setOemId(Long oemId) {
		this.oemId = oemId;
		return this;
	}

	public String getAdminLogo() {
		return adminLogo;
	}

	public FbOemConfig setAdminLogo(String adminLogo) {
		this.adminLogo = adminLogo;
		return this;
	}

	public String getWelcomeWord() {
		return welcomeWord;
	}

	public FbOemConfig setWelcomeWord(String welcomeWord) {
		this.welcomeWord = welcomeWord;
		return this;
	}

	public String getAdminUrl() {
		return adminUrl;
	}

	public FbOemConfig setAdminUrl(String adminUrl) {
		this.adminUrl = adminUrl;
		return this;
	}

	public String getAgentLogo() {
		return agentLogo;
	}

	public FbOemConfig setAgentLogo(String agentLogo) {
		this.agentLogo = agentLogo;
		return this;
	}

	public String getAgentUrl() {
		return agentUrl;
	}

	public FbOemConfig setAgentUrl(String agentUrl) {
		this.agentUrl = agentUrl;
		return this;
	}

	public String getUserLogo() {
		return userLogo;
	}

	public FbOemConfig setUserLogo(String userLogo) {
		this.userLogo = userLogo;
		return this;
	}

	public String getUserUrl() {
		return userUrl;
	}

	public FbOemConfig setUserUrl(String userUrl) {
		this.userUrl = userUrl;
		return this;
	}

	public String getTopMsg() {
		return topMsg;
	}

	public FbOemConfig setTopMsg(String topMsg) {
		this.topMsg = topMsg;
		return this;
	}

	public String getBottomMsg() {
		return bottomMsg;
	}

	public FbOemConfig setBottomMsg(String bottomMsg) {
		this.bottomMsg = bottomMsg;
		return this;
	}

	public String getVoiceRemind() {
		return voiceRemind;
	}

	public FbOemConfig setVoiceRemind(String voiceRemind) {
		this.voiceRemind = voiceRemind;
		return this;
	}

	public Integer getVoiceOnOff() {
		return voiceOnOff;
	}

	public FbOemConfig setVoiceOnOff(Integer voiceOnOff) {
		this.voiceOnOff = voiceOnOff;
		return this;
	}

	public Integer getBindProtocol() {
		return bindProtocol;
	}

	public FbOemConfig setBindProtocol(Integer bindProtocol) {
		this.bindProtocol = bindProtocol;
		return this;
	}

	public Integer getVideoOnOff() {
		return videoOnOff;
	}

	public FbOemConfig setVideoOnOff(Integer videoOnOff) {
		this.videoOnOff = videoOnOff;
		return this;
	}

	public String getRedPacketNotice() {
		return redPacketNotice;
	}

	public FbOemConfig setRedPacketNotice(String redPacketNotice) {
		this.redPacketNotice = redPacketNotice;
		return this;
	}

	public String getRedPacketMsg() {
		return redPacketMsg;
	}

	public FbOemConfig setRedPacketMsg(String redPacketMsg) {
		this.redPacketMsg = redPacketMsg;
		return this;
	}

	public String getSubDomain() {
		return subDomain;
	}

	public FbOemConfig setSubDomain(String subDomain) {
		this.subDomain = subDomain;
		return this;
	}

	public String getAdminLoginBg() {
		return adminLoginBg;
	}

	public FbOemConfig setAdminLoginBg(String adminLoginBg) {
		this.adminLoginBg = adminLoginBg;
		return this;
	}

	public String getAdminLoginLogo() {
		return adminLoginLogo;
	}

	public FbOemConfig setAdminLoginLogo(String adminLoginLogo) {
		this.adminLoginLogo = adminLoginLogo;
		return this;
	}

	public String getAdminLoginTitle() {
		return adminLoginTitle;
	}

	public FbOemConfig setAdminLoginTitle(String adminLoginTitle) {
		this.adminLoginTitle = adminLoginTitle;
		return this;
	}

	public String getAgentLoginBg() {
		return agentLoginBg;
	}

	public FbOemConfig setAgentLoginBg(String agentLoginBg) {
		this.agentLoginBg = agentLoginBg;
		return this;
	}

	public String getAgentLoginLogo() {
		return agentLoginLogo;
	}

	public FbOemConfig setAgentLoginLogo(String agentLoginLogo) {
		this.agentLoginLogo = agentLoginLogo;
		return this;
	}

	public String getAgentLoginTitle() {
		return agentLoginTitle;
	}

	public FbOemConfig setAgentLoginTitle(String agentLoginTitle) {
		this.agentLoginTitle = agentLoginTitle;
		return this;
	}

	public String getUserLoginBg() {
		return userLoginBg;
	}

	public FbOemConfig setUserLoginBg(String userLoginBg) {
		this.userLoginBg = userLoginBg;
		return this;
	}

	public String getUserLoginLogo() {
		return userLoginLogo;
	}

	public FbOemConfig setUserLoginLogo(String userLoginLogo) {
		this.userLoginLogo = userLoginLogo;
		return this;
	}

	public String getUserLoginTitle() {
		return userLoginTitle;
	}

	public FbOemConfig setUserLoginTitle(String userLoginTitle) {
		this.userLoginTitle = userLoginTitle;
		return this;
	}

	public String getWxOfficialAccount() {
		return wxOfficialAccount;
	}

	public FbOemConfig setWxOfficialAccount(String wxOfficialAccount) {
		this.wxOfficialAccount = wxOfficialAccount;
		return this;
	}

	public String getQrcodeBackground() {
		return qrcodeBackground;
	}

	public FbOemConfig setQrcodeBackground(String qrcodeBackground) {
		this.qrcodeBackground = qrcodeBackground;
		return this;
	}

	public String getAgentAdText() {
		return agentAdText;
	}

	public FbOemConfig setAgentAdText(String agentAdText) {
		this.agentAdText = agentAdText;
		return this;
	}

	public String getWapIndexTitle() {
		return wapIndexTitle;
	}

	public FbOemConfig setWapIndexTitle(String wapIndexTitle) {
		this.wapIndexTitle = wapIndexTitle;
		return this;
	}

	public String getWapDefaultHeader() {
		return wapDefaultHeader;
	}

	public FbOemConfig setWapDefaultHeader(String wapDefaultHeader) {
		this.wapDefaultHeader = wapDefaultHeader;
		return this;
	}

	public String getWapDefaultNickname() {
		return wapDefaultNickname;
	}

	public FbOemConfig setWapDefaultNickname(String wapDefaultNickname) {
		this.wapDefaultNickname = wapDefaultNickname;
		return this;
	}

	public String getWapUserHeader() {
		return wapUserHeader;
	}

	public FbOemConfig setWapUserHeader(String wapUserHeader) {
		this.wapUserHeader = wapUserHeader;
		return this;
	}

	public String getProtocolTitle() {
		return protocolTitle;
	}

	public FbOemConfig setProtocolTitle(String protocolTitle) {
		this.protocolTitle = protocolTitle;
		return this;
	}

	public String getProtocolContent() {
		return protocolContent;
	}

	public FbOemConfig setProtocolContent(String protocolContent) {
		this.protocolContent = protocolContent;
		return this;
	}

	public String getWxMpAppid() {
		return wxMpAppid;
	}

	public FbOemConfig setWxMpAppid(String wxMpAppid) {
		this.wxMpAppid = wxMpAppid;
		return this;
	}

	public String getWxMpAppsecret() {
		return wxMpAppsecret;
	}

	public FbOemConfig setWxMpAppsecret(String wxMpAppsecret) {
		this.wxMpAppsecret = wxMpAppsecret;
		return this;
	}

	public String getWapActiveBand() {
		return wapActiveBand;
	}

	public FbOemConfig setWapActiveBand(String wapActiveBand) {
		this.wapActiveBand = wapActiveBand;
		return this;
	}

	public String getWapMemberBand() {
		return wapMemberBand;
	}

	public FbOemConfig setWapMemberBand(String wapMemberBand) {
		this.wapMemberBand = wapMemberBand;
		return this;
	}

	public String getWebLogo() {
		return webLogo;
	}

	public FbOemConfig setWebLogo(String webLogo) {
		this.webLogo = webLogo;
		return this;
	}

	public String getAppCustomerMobile() {
		return appCustomerMobile;
	}

	public FbOemConfig setAppCustomerMobile(String appCustomerMobile) {
		this.appCustomerMobile = appCustomerMobile;
		return this;
	}

	public String getAppBindText() {
		return appBindText;
	}

	public FbOemConfig setAppBindText(String appBindText) {
		this.appBindText = appBindText;
		return this;
	}

	public Integer getConfigType() {
		return configType;
	}

	public FbOemConfig setConfigType(Integer configType) {
		this.configType = configType;
		return this;
	}

	public Integer getIsShowProtocol() {
		return isShowProtocol;
	}

	public FbOemConfig setIsShowProtocol(Integer isShowProtocol) {
		this.isShowProtocol = isShowProtocol;
		return this;
	}

	public String getPaySuccessNotice() {
		return paySuccessNotice;
	}

	public FbOemConfig setPaySuccessNotice(String paySuccessNotice) {
		this.paySuccessNotice = paySuccessNotice;
		return this;
	}

	public String getQrCodeUrl() {
		return qrCodeUrl;
	}

	public FbOemConfig setQrCodeUrl(String qrCodeUrl) {
		this.qrCodeUrl = qrCodeUrl;
		return this;
	}

	public String getPostDocument() {
		return postDocument;
	}

	public FbOemConfig setPostDocument(String postDocument) {
		this.postDocument = postDocument;
		return this;
	}

	public String getPostLogo() {
		return postLogo;
	}

	public FbOemConfig setPostLogo(String postLogo) {
		this.postLogo = postLogo;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbOemConfig setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbOemConfig setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String OEM_ID = "oem_id";

	public static final String ADMIN_LOGO = "admin_logo";

	public static final String WELCOME_WORD = "welcome_word";

	public static final String ADMIN_URL = "admin_url";

	public static final String AGENT_LOGO = "agent_logo";

	public static final String AGENT_URL = "agent_url";

	public static final String USER_LOGO = "user_logo";

	public static final String USER_URL = "user_url";

	public static final String TOP_MSG = "top_msg";

	public static final String BOTTOM_MSG = "bottom_msg";

	public static final String VOICE_REMIND = "voice_remind";

	public static final String VOICE_ON_OFF = "voice_on_off";

	public static final String BIND_PROTOCOL = "bind_protocol";

	public static final String VIDEO_ON_OFF = "video_on_off";

	public static final String RED_PACKET_NOTICE = "red_packet_notice";

	public static final String RED_PACKET_MSG = "red_packet_msg";

	public static final String SUB_DOMAIN = "sub_domain";

	public static final String ADMIN_LOGIN_BG = "admin_login_bg";

	public static final String ADMIN_LOGIN_LOGO = "admin_login_logo";

	public static final String ADMIN_LOGIN_TITLE = "admin_login_title";

	public static final String AGENT_LOGIN_BG = "agent_login_bg";

	public static final String AGENT_LOGIN_LOGO = "agent_login_logo";

	public static final String AGENT_LOGIN_TITLE = "agent_login_title";

	public static final String USER_LOGIN_BG = "user_login_bg";

	public static final String USER_LOGIN_LOGO = "user_login_logo";

	public static final String USER_LOGIN_TITLE = "user_login_title";

	public static final String WX_OFFICIAL_ACCOUNT = "wx_official_account";

	public static final String QRCODE_BACKGROUND = "qrcode_background";

	public static final String AGENT_AD_TEXT = "agent_ad_text";

	public static final String WAP_INDEX_TITLE = "wap_index_title";

	public static final String WAP_DEFAULT_HEADER = "wap_default_header";

	public static final String WAP_DEFAULT_NICKNAME = "wap_default_nickname";

	public static final String WAP_USER_HEADER = "wap_user_header";

	public static final String PROTOCOL_TITLE = "protocol_title";

	public static final String PROTOCOL_CONTENT = "protocol_content";

	public static final String WX_MP_APPID = "wx_mp_appid";

	public static final String WX_MP_APPSECRET = "wx_mp_appsecret";

	public static final String WAP_ACTIVE_BAND = "wap_active_band";

	public static final String WAP_MEMBER_BAND = "wap_member_band";

	public static final String WEB_LOGO = "web_logo";

	public static final String APP_CUSTOMER_MOBILE = "app_customer_mobile";

	public static final String APP_BIND_TEXT = "app_bind_text";

	public static final String CONFIG_TYPE = "config_type";

	public static final String IS_SHOW_PROTOCOL = "is_show_protocol";

	public static final String PAY_SUCCESS_NOTICE = "pay_success_notice";

	public static final String QR_CODE_URL = "qr_code_url";

	public static final String POST_DOCUMENT = "post_document";

	public static final String POST_LOGO = "post_logo";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbOemConfig{" +
			", id=" + id +
			", oemId=" + oemId +
			", adminLogo=" + adminLogo +
			", welcomeWord=" + welcomeWord +
			", adminUrl=" + adminUrl +
			", agentLogo=" + agentLogo +
			", agentUrl=" + agentUrl +
			", userLogo=" + userLogo +
			", userUrl=" + userUrl +
			", topMsg=" + topMsg +
			", bottomMsg=" + bottomMsg +
			", voiceRemind=" + voiceRemind +
			", voiceOnOff=" + voiceOnOff +
			", bindProtocol=" + bindProtocol +
			", videoOnOff=" + videoOnOff +
			", redPacketNotice=" + redPacketNotice +
			", redPacketMsg=" + redPacketMsg +
			", subDomain=" + subDomain +
			", adminLoginBg=" + adminLoginBg +
			", adminLoginLogo=" + adminLoginLogo +
			", adminLoginTitle=" + adminLoginTitle +
			", agentLoginBg=" + agentLoginBg +
			", agentLoginLogo=" + agentLoginLogo +
			", agentLoginTitle=" + agentLoginTitle +
			", userLoginBg=" + userLoginBg +
			", userLoginLogo=" + userLoginLogo +
			", userLoginTitle=" + userLoginTitle +
			", wxOfficialAccount=" + wxOfficialAccount +
			", qrcodeBackground=" + qrcodeBackground +
			", agentAdText=" + agentAdText +
			", wapIndexTitle=" + wapIndexTitle +
			", wapDefaultHeader=" + wapDefaultHeader +
			", wapDefaultNickname=" + wapDefaultNickname +
			", wapUserHeader=" + wapUserHeader +
			", protocolTitle=" + protocolTitle +
			", protocolContent=" + protocolContent +
			", wxMpAppid=" + wxMpAppid +
			", wxMpAppsecret=" + wxMpAppsecret +
			", wapActiveBand=" + wapActiveBand +
			", wapMemberBand=" + wapMemberBand +
			", webLogo=" + webLogo +
			", appCustomerMobile=" + appCustomerMobile +
			", appBindText=" + appBindText +
			", configType=" + configType +
			", isShowProtocol=" + isShowProtocol +
			", paySuccessNotice=" + paySuccessNotice +
			", qrCodeUrl=" + qrCodeUrl +
			", postDocument=" + postDocument +
			", postLogo=" + postLogo +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}


}
