package com.fshows.lifecircle.user.service.dao;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.fshows.lifecircle.user.service.domain.po.FbUserOemChildren;
import com.fshows.lifecircle.user.service.domain.po.RoleUserPO;
import com.fshows.lifecircle.user.service.domain.query.RoleUserQuery;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * OEM商子账户信息表 Mapper 接口
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
public interface FbUserOemChildrenMapper extends BaseMapper<FbUserOemChildren> {

    /**
     * 查询列表
     *
     * @param query
     * @return
     */
    List<RoleUserPO> findListByPage(RoleUserQuery query);

    /**
     * 总条数
     *
     * @param query
     * @return
     */
    Integer findListByPageCount(RoleUserQuery query);

    List<Map<String, Object>> selectOemIdAndNameByOemId(@Param("oemId") Long oemId);


}
