/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.store.business.impl.biz;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.fshows.lifecircle.service.store.business.biz.IStoreService;
import com.fshows.lifecircle.service.store.business.db.IFbStoreExamineRecordService;
import com.fshows.lifecircle.service.store.business.db.IFbStoreInfoService;
import com.fshows.lifecircle.service.store.dao.FbStoreInfoMapper;
import com.fshows.lifecircle.service.store.domain.po.FbStoreExamineRecord;
import com.fshows.lifecircle.service.store.domain.po.FbStoreInfo;
import com.fshows.lifecircle.service.store.domain.po.StoreQueryPO;
import com.fshows.lifecircle.service.store.openapi.facade.domain.StoreExamineRecordParam;
import com.fshows.lifecircle.service.store.openapi.facade.domain.StoreInfoResult;
import com.fshows.lifecircle.service.store.openapi.facade.domain.StoreParam;
import com.fshows.lifecircle.service.store.openapi.facade.domain.StoreQueryParam;
import com.fshows.lifecircle.service.utils.KeyGenerator;
import com.fshows.lifecircle.service.utils.KeyTypeEnum;
import com.fshows.lifecircle.service.utils.domain.PageResult;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StoreService
implements IStoreService {
    @Autowired
    private IFbStoreExamineRecordService fbStoreExamineRecordService;
    @Autowired
    private IFbStoreInfoService fbStoreInfoService;
    @Autowired
    private FbStoreInfoMapper fbStoreInfoMapper;

    @Override
    public Long addOrUpdateStore(StoreParam param) {
        FbStoreInfo storeInfo = new FbStoreInfo();
        BeanUtils.copyProperties((Object)param, (Object)storeInfo);
        Long storeId = param.getStoreId();
        if (storeId == null) {
            Long storeKey = KeyGenerator.getKeyByType((KeyTypeEnum)KeyTypeEnum.STORE_KEY);
            storeInfo.setStoreId(storeKey);
            boolean insert = this.fbStoreInfoService.insert(storeInfo);
            return insert ? storeKey : 0L;
        }
        boolean update = this.fbStoreInfoService.update(storeInfo, new EntityWrapper().eq("store_id", (Object)storeId));
        return update ? storeId : 0L;
    }

    @Override
    public StoreInfoResult getByStoreId(Long storeId) {
        FbStoreInfo storeInfo = (FbStoreInfo)this.fbStoreInfoService.selectOne(new EntityWrapper().eq("is_del", (Object)0).eq("store_id", (Object)storeId));
        if (storeInfo != null) {
            StoreInfoResult source = new StoreInfoResult();
            BeanUtils.copyProperties((Object)storeInfo, (Object)source);
            return source;
        }
        return null;
    }

    @Override
    public PageResult<StoreInfoResult> findByStoreList(StoreQueryParam param) {
        StoreQueryPO storeQueryPO = new StoreQueryPO();
        BeanUtils.copyProperties((Object)param, (Object)storeQueryPO);
        Integer pageStart = param.getPage();
        Integer pageSize = param.getPageSize();
        storeQueryPO.setPageStart(Integer.valueOf((pageStart - 1) * pageSize));
        List list = this.fbStoreInfoMapper.findByStoreQueryParam(storeQueryPO);
        if (list != null || list.size() != 0) {
            Integer count = this.fbStoreInfoMapper.countByStoreQueryParam(storeQueryPO);
            return new PageResult(count, list.stream().map(item -> {
                StoreInfoResult storeInfoResult = new StoreInfoResult();
                BeanUtils.copyProperties((Object)item, (Object)storeInfoResult);
                return storeInfoResult;
            }).collect(Collectors.toList()));
        }
        return new PageResult(Integer.valueOf(0), (List)Lists.newArrayList());
    }

    @Override
    public Boolean addOrUpdateStoreExamineRecord(StoreExamineRecordParam param) {
        Long storeId = param.getStoreId();
        FbStoreExamineRecord examineRecord = new FbStoreExamineRecord();
        BeanUtils.copyProperties((Object)param, (Object)examineRecord);
        if (param.getIsAdd().booleanValue()) {
            examineRecord.setExamineId(KeyGenerator.getKeyByType((KeyTypeEnum)KeyTypeEnum.COMMON_KEY));
            return this.fbStoreExamineRecordService.insert(examineRecord);
        }
        return this.fbStoreExamineRecordService.update(examineRecord, new EntityWrapper().eq("store_id", (Object)storeId).orderBy("create_time", false).last(" LIMIT 1"));
    }
}

