/**
 * 项目：lifecircle-service-store
 * 包名：com.fshows.lifecircle.service.store.business.biz
 * 功能：
 * 创建时间：2018-01-15 15:47
 * 更新记录：
 *
 * @author BuHao
 */
package com.fshows.lifecircle.service.store.business.biz;

import com.fshows.lifecircle.service.store.openapi.facade.domain.StoreExamineRecordParam;
import com.fshows.lifecircle.service.store.openapi.facade.domain.StoreInfoResult;
import com.fshows.lifecircle.service.store.openapi.facade.domain.StoreParam;
import com.fshows.lifecircle.service.store.openapi.facade.domain.StoreQueryParam;
import com.fshows.lifecircle.service.utils.domain.PageResult;

/**
 * 项目：lifecircle-service-store
 * 包名：com.fshows.lifecircle.service.store.business.biz
 * 功能：
 * 创建时间：2018-01-15 15:47
 * 更新记录：
 * @author BuHao
 */
public interface IStoreService {

  /**
   * 添加店铺
   * @param param
   * @return
   */
  Long addOrUpdateStore(StoreParam param);

  /**
   * 根据 storeId 获得店铺详情
   * @param storeId
   * @return
   */
  StoreInfoResult getByStoreId(Long storeId);

  /**
   * 店铺列表接口
   * @return
   */
 PageResult<StoreInfoResult> findByStoreList(StoreQueryParam param);

  /**
   * 添加修改店铺审核记录
   * @param param
   * @return
   */
 Boolean addOrUpdateStoreExamineRecord(StoreExamineRecordParam param);
}
