/**
 * Copyright (c) 2018, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.store.business.impl.biz;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.fshows.lifecircle.service.store.business.biz.IStoreService;
import com.fshows.lifecircle.service.store.business.db.IFbStoreExamineRecordService;
import com.fshows.lifecircle.service.store.business.db.IFbStoreInfoService;
import com.fshows.lifecircle.service.store.dao.FbStoreInfoMapper;
import com.fshows.lifecircle.service.store.domain.po.FbStoreExamineRecord;
import com.fshows.lifecircle.service.store.domain.po.FbStoreInfo;
import com.fshows.lifecircle.service.store.domain.po.StoreQueryPO;
import com.fshows.lifecircle.service.store.openapi.facade.domain.StoreExamineRecordParam;
import com.fshows.lifecircle.service.store.openapi.facade.domain.StoreInfoResult;
import com.fshows.lifecircle.service.store.openapi.facade.domain.StoreParam;
import com.fshows.lifecircle.service.store.openapi.facade.domain.StoreQueryParam;
import com.fshows.lifecircle.service.utils.KeyGenerator;
import com.fshows.lifecircle.service.utils.KeyTypeEnum;
import com.fshows.lifecircle.service.utils.domain.PageResult;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 项目：lifecircle-service-store
 * 包名：com.fshows.lifecircle.service.store.business.impl.biz
 * 功能：
 * 创建时间：2018-01-16 11:07
 * 更新记录：
 *
 * @author BuHao
 */
@Service
public class StoreService implements IStoreService {

  @Autowired
  private IFbStoreExamineRecordService fbStoreExamineRecordService;
  @Autowired
  private IFbStoreInfoService fbStoreInfoService;
  @Autowired
  private FbStoreInfoMapper fbStoreInfoMapper;

  /**
   * 添加店铺
   */
  @Override
  public Long addOrUpdateStore(StoreParam param) {

    // 赋值
    FbStoreInfo storeInfo = new FbStoreInfo();
    BeanUtils.copyProperties(param, storeInfo);

    Long storeId = param.getStoreId();
    // 新增
    if (storeId == null) {

      // 生成 storeId
      Long storeKey = KeyGenerator.getKeyByType(KeyTypeEnum.STORE_KEY);
      storeInfo.setStoreId(storeKey);

      // 入库
      boolean insert = fbStoreInfoService.insert(storeInfo);

      return insert ? storeKey : 0L;
      // 修改
    } else {

      boolean update = fbStoreInfoService
          .update(storeInfo, new EntityWrapper<FbStoreInfo>().eq(FbStoreInfo.STORE_ID, storeId));
      return update ? storeId : 0L;
    }
  }

  /**
   * 根据 storeId 获得店铺详情
   */
  @Override
  public StoreInfoResult getByStoreId(Long storeId) {

    // 查询
    FbStoreInfo storeInfo = fbStoreInfoService.selectOne(
        new EntityWrapper<FbStoreInfo>().eq(FbStoreInfo.IS_DEL, 0)
            .eq(FbStoreInfo.STORE_ID, storeId));

    if (storeInfo != null) {

      // 赋值
      StoreInfoResult source = new StoreInfoResult();
      BeanUtils.copyProperties(storeInfo, source);

      return source;
    }
    return null;
  }

  /**
   * 店铺列表接口
   */
  @Override
  public PageResult<StoreInfoResult> findByStoreList(StoreQueryParam param) {

    // 赋值
    StoreQueryPO storeQueryPO = new StoreQueryPO();
    BeanUtils.copyProperties(param, storeQueryPO);

    // 计算分页参数
    Integer pageStart = param. getPage();
    Integer pageSize = param.getPageSize();
    storeQueryPO.setPageStart((pageStart - 1) * pageSize);

    // 查询
    List<FbStoreInfo> list = fbStoreInfoMapper.findByStoreQueryParam(storeQueryPO);
    if (list != null || list.size() != 0) {

      // 统计条数
      Integer count = fbStoreInfoMapper.countByStoreQueryParam(storeQueryPO);
      // 返回分页数据
      return new PageResult<>(count, list.stream().map(item -> {
        StoreInfoResult storeInfoResult = new StoreInfoResult();
        BeanUtils.copyProperties(item, storeInfoResult);
        return storeInfoResult;
      }).collect(Collectors.toList()));
    } else {

      return new PageResult(0, Lists.newArrayList());
    }

  }

  /**
   * 添加修改店铺审核记录
   */
  @Override
  public Boolean addOrUpdateStoreExamineRecord(StoreExamineRecordParam param) {

    Long storeId = param.getStoreId();

    // 赋值
    FbStoreExamineRecord examineRecord = new FbStoreExamineRecord();
    BeanUtils.copyProperties(param, examineRecord);

    // 添加
    if (storeId == null || storeId == 0) {

      examineRecord.setExamineId(KeyGenerator.getKeyByType(KeyTypeEnum.COMMON_KEY));
      return fbStoreExamineRecordService.insert(examineRecord);

      // 修改
    } else {

      return fbStoreExamineRecordService.update(examineRecord,
          new EntityWrapper<FbStoreExamineRecord>().eq(FbStoreExamineRecord.STORE_ID, storeId).orderBy(FbStoreExamineRecord.CREATE_TIME, false).last(" LIMIT 1"));
    }
  }
}
