/**
 * Copyright (c) 2018, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.store.openapi.facade.domain;

import java.util.Date;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 项目：lifecircle-service-store
 * 包名：com.fshows.lifecircle.service.store.openapi.facade.domain
 * 功能：
 * 创建时间：2018-01-15 15:31
 * 更新记录：
 *
 * @author BuHao
 */
@Data
@Accessors(chain = true)
public class StoreInfoResult {

  /**
   * 门店ID
   */
  private Long storeId;
  /**
   * 门店名称
   */
  private String storeName;
  /**
   * 是否删除 0 未删除 1 已删除
   */

  private Integer isDel;
  /**
   * 所属商户ID
   */
  private Long mid;
  /**
   * 商家名称
   */
  private String mTitle;
  /**
   * 所属代理商ID
   */
  private Long agentId;
  /**
   * 代理商公司名称
   */
  private String agentCompany;
  /**
   * 所属OEM商ID
   */
  private Long oemId;
  /**
   * OEM商名称(OEM表admin_title)
   */
  private String oemTitle;
  /**
   * 审核状态 0未审核 1代理商审核通过（系统待处理） 2代理商审核拒绝 3系统审核通过 4系统审核拒绝
   */
  private Integer status;
  /**
   * 上架状态 0（待营业） 1 （营业中）2已关闭
   */
  private Integer isOnline;
  /**
   * 口碑分类ID
   */
  private String categoryId;
  /**
   * 省份code（gaode）
   */
  private String provinceCode;
  /**
   * 省份名称（gaode）
   */
  private String provinceName;
  /**
   * 城市code（gaode）
   */
  private String cityCode;
  /**
   * 城市名称（gaode）
   */
  private String cityName;
  /**
   * 区域code（gaode）
   */
  private String areaCode;
  /**
   * 区域名称（gaode）
   */
  private String areaName;
  /**
   * 详细地址
   */
  private String address;
  /**
   * 经度
   */
  private Float longitude;
  /**
   * 维度
   */
  private Float latitude;
  /**
   * 门店电话
   */
  private String tel;
  /**
   * 每日营业开门时间
   */
  private String openTime;
  /**
   * 每日营业关门时间
   */
  private String endTime;
  /**
   * 人均消费价格
   */
  private Integer avgPrice;
  /**
   * 提供服务，以逗号分割的字符串，1停车位，2包厢，3WIFI，4无烟区
   */
  private String service;
  /**
   * 门店简介
   */
  private String storeBrief;
  /**
   * 品牌LOGO
   */
  private String storeLogo;
  /**
   * 门店图片，以JSON格式存储
   */
  private String storeImage;
  /**
   * 经营许可证照片
   */
  private String licensePhoto;
  /**
   * 营业执照照片
   */
  private String idPhoto;
  /**
   * 营业执照编号/名称
   */
  private String lincenseId;
  /**
   * 添加门店渠道 1：APP
   */
  private Integer joinChannel;
  /**
   * 创建时间
   */
  private Date createTime;
  /**
   * 类目名称
   */
  private String categoryName;

}
