/**
 * Copyright (c) 2018, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.store.openapi.facade.domain;

import com.fshows.lifecircle.service.utils.domain.PageQueryParam;
import java.util.Date;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 项目：lifecircle-service-store
 * 包名：com.fshows.lifecircle.service.store.openapi.facade.domain
 * 功能：
 * 创建时间：2018-01-15 16:10
 * 更新记录：
 * @author BuHao
 */
@Data
@Accessors(chain = true)
public class StoreQueryParam extends PageQueryParam {

  /**
   * 店铺 id
   */
  private Long storeId;
  /**
   * 店铺名称
   */
  private String storeName;
  /**
   * 店铺状态
   */
  private Integer status;
  /**
   * oem Id
   */
  private Long oemId;
  /**
   * 代理商 Id
   */
  private Long agentId;
  /**
   * 商户 id
   */
  private Long mid;
  /**
   * 审核状态
   */
  private Integer examineStatus;
  /**
   * 口碑分类ID
   */
  private String categoryId;
  /**
   * 省份code（gaode）
   */
  private String provinceCode;
  /**
   * 城市code（gaode）
   */
  private String cityCode;
  /**
   * 区域code（gaode）
   */
  private String areaCode;
  /**
   * 店铺添加时间
   */
  private Date addStoreStartTime;
  /**
   * 店铺添加结束时间
   */
  private Date addStoreEndTime;
}
