/**
 * Copyright (c) 2018, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.store.openapi.facade.domain;

import java.util.Date;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 项目：lifecircle-service-store
 * 包名：com.fshows.lifecircle.service.store.openapi.facade.domain
 * 功能：
 * 创建时间：2018-01-17 09:19
 * 更新记录：
 *
 * @author BuHao
 */
@Data
@Accessors(chain = true)
public class StoreExamineRecordParam {

  /**
   * 审核编号
   */
  private Long examineId;
  /**
   * 门店ID
   */
  private Long storeId;
  /**
   * 门店名称
   */
  private String storeName;
  /**
   * 审核信息
   */
  private String examineJson;
  /**
   * 总店信息，添加异地门店审核时候使用 json 包含总部地址和名称
   */
  private String mainStoreInfo;
  /**
   * 审核状态 0未审核 1代理商审核通过（系统待处理） 2代理商审核拒绝 3系统审核通过 4系统审核拒绝
   */
  private Integer examineStatus;
  /**
   * 审核时间
   */
  private Long examineTime;
  /**
   * 代理商审核人用户ID
   */
  private Long examineUid;
  /**
   * 代理商审核人用户名称
   */
  private String examineUsername;
  /**
   * 代理商拒绝理由
   */
  private String rejectReason;
  /**
   * 系统审核时间
   */
  private Long secondExamineTime;
  /**
   * 系统审核人用户ID
   */
  private Long secondExamineUid;
  /**
   * 系统审核人用户名称
   */
  private String secondExamineUsername;
  /**
   * 系统拒绝理由
   */
  private String secondRejectReason;
  /**
   * 是否删除 0 未删除 1 已删除
   */
  private Integer isDel;
  /**
   * 创建时间
   */
  private Date createTime;
  /**
   * 修改时间
   */
  private Date updateTime;
  /**
   * 是否添加
   */
  private Boolean isAdd = true;
}
