package com.fshows.lifecircle.service.pay.openapi.facade.domain.rate;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class FbRateChangeLogParam implements Serializable {

    private static final long serialVersionUID = 1L;


    /**
     * 业务唯一ID type=1 oem_id type=2 agent_id type=3 mid
     */
    private Long bizId;
    /**
     * 变更类型 1OEM商扣率 2代理商扣率 3商户扣率
     */
    private Integer type;
    /**
     * 渠道 id
     */
    private Integer channelId;
    /**
     * 佣金扣率
     */
    private BigDecimal rate;
    /**
     * 最大利润率
     */
    private BigDecimal maxRate;
    /**
     * 最小利润率
     */
    private BigDecimal minRate;
    /**
     * 历史利润率
     */
    private BigDecimal rateOld;
    /**
     * 历史最大利润率
     */
    private BigDecimal maxRateOld;
    /**
     * 历史最小利润率
     */
    private BigDecimal minRateOld;
    /**
     * 更改人
     */
    private String username;
    /**
     * 备注
     */
    private String memo;

    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改时间
     */
    private Date updateTime;
}