package com.fshows.lifecircle.service.pay.openapi.facade.domain.rate;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class FbRateBaseResult implements Serializable {

    private static final long serialVersionUID = 1L;


    /**
     * OEM商ID（银行）
     */
    private Long oemId;
    /**
     * 支付渠道ID
     */
    private Integer channelId;
    /**
     * 银行利润率
     */
    private BigDecimal bankRate;
    /**
     * 支付平台利润率
     */
    private BigDecimal payTypeRate;
    /**
     * 网关利润率（技术服务费）
     */
    private BigDecimal gatewayRate;
    /**
     * 备注
     */
    private String memo;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改时间
     */
    private Date updateTime;
}