package com.fshows.lifecircle.service.pay.openapi.facade.domain.rate;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class FbOemRateParam implements Serializable {

    private static final long serialVersionUID = 1L;


    /**
     * 支付渠道
     */
    private Integer channelId;
    /**
     * oem_id
     */
    private Long oemId;
    /**
     * 生活圈利润率
     */
    private BigDecimal rate;
    /**
     * OEM最大利润率
     */
    private BigDecimal maxRate;
    /**
     * OEM最小利润率
     */
    private BigDecimal minRate;
    /**
     * 备注
     */
    private String memo;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改时间
     */
    private Date updateTime;
}